using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using gov.va.med.vbecs.Common;
using gov.va.med.vbecs.DAL.VAL;

namespace gov.va.med.vbecs.GUI
{
	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>Brian    lin</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>2/24/2003</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	///<summary></summary>
	public class FrmPendingOrderSearch : gov.va.med.vbecs.GUI.VbecsBaseForm
	{

		#region variables

		// The orders object is used to get all of the order for this UC.  It contains
		// must of the business logic.
		BOL.Orders _orders;
		private System.Data.DataRow _drPrevious = null;
		bool _loading = false; // CR2909
        Common.AcceptOrderStatus _status = Common.AcceptOrderStatus.None; // CR3399

		#region system generated variables

		private System.Windows.Forms.Button btnCancel;
		private System.Windows.Forms.HelpProvider helpProvider1;
		private System.Windows.Forms.ToolTip toolTip1;
		private System.Windows.Forms.GroupBox groupBox2;
		private System.Windows.Forms.PictureBox pictureBox8;
		private System.Windows.Forms.PictureBox pictureBox4;
		private System.Windows.Forms.Panel pnlTreeView;
		private System.Windows.Forms.TreeView tvPOL;
		private System.Windows.Forms.ImageList imageList1;
		private System.Windows.Forms.GroupBox grpImage2;
		private System.Windows.Forms.GroupBox grpSearchPOL;
		private gov.va.med.vbecs.GUI.controls.BarcodeTextbox txtSpecimen;
		private System.Windows.Forms.TextBox txtPatient;
		private System.Windows.Forms.TextBox txtOrder;
		private System.Windows.Forms.PictureBox picPOL;
		private System.Windows.Forms.Label lblOrderGroup;
		private System.Windows.Forms.Label lblSearchOrder;
		private System.Windows.Forms.Label lblSearchPatient;
		private System.Windows.Forms.Label lblSearchSpecimen;
		private System.Windows.Forms.Label lblSelectedPatient;
		private System.Windows.Forms.TextBox txtPatientName;
		private System.Windows.Forms.Label label2;
		private System.Windows.Forms.Label lblPhysician;
		private System.Windows.Forms.Label lblDateWanted;
		private System.Windows.Forms.Panel pnlSelectedOrderHeader;
		private System.Windows.Forms.Button btnMSBOS;
		private System.Windows.Forms.Button btnAutoDirUnits;
		private System.Windows.Forms.Button btnOrderDetails;
		private System.Windows.Forms.TextBox txtABORH;
		private System.Windows.Forms.TextBox txtPatientLocation;
		private System.Windows.Forms.Label lblPatientLocation;
		private System.Windows.Forms.TextBox txtSSN;
		private System.Windows.Forms.TextBox txtPhysician;
		private System.Windows.Forms.TextBox txtProcedure;
		private System.Windows.Forms.Label lblProcedure;
		private System.Windows.Forms.Label lblSpecimen;
		private System.Windows.Forms.Label lblComments;
		private System.Windows.Forms.TextBox txtComments;
		private System.Windows.Forms.Label label3;
		private System.Windows.Forms.Label label5;
		private System.Windows.Forms.ListView lvSubOrders;
		private System.Windows.Forms.ColumnHeader colIcon;
		private System.Windows.Forms.ColumnHeader colProcedure;
		private System.Windows.Forms.ColumnHeader colPatientName;
		private System.Windows.Forms.ColumnHeader colSpecimenStatus;
		private System.Windows.Forms.ColumnHeader colProvider;
		private System.Windows.Forms.Panel pnlPOL;
		private System.Windows.Forms.Panel pnlSelectedOrderDetails;
		private System.Windows.Forms.Panel pnlOrderGroupHeader;
		private System.Windows.Forms.Panel pnlSelectedOrder;
		private System.Windows.Forms.Splitter splitter1;
		private System.Windows.Forms.Splitter splitter2;
		private System.Windows.Forms.PictureBox pictureBox2;
		private System.Windows.Forms.Label label6;
		private System.Windows.Forms.Panel pnpPOL;
		private System.Windows.Forms.Label lblPatientID;
		private System.Windows.Forms.ColumnHeader colPatientID;
		private System.Windows.Forms.ColumnHeader colPatientLocation;
		private System.Windows.Forms.ColumnHeader colDateWanted;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnSearch;
		private System.Windows.Forms.Button btnClear;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnAccept;
		private System.Windows.Forms.ColumnHeader colUrgency;
		private System.Windows.Forms.ColumnHeader colDateReceived;
		private System.Windows.Forms.Button btnReject;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.GroupBox grpSplit;
		private System.Windows.Forms.TextBox txtLabOrderID;
		private System.Windows.Forms.TextBox txtQuantity;
		private System.Windows.Forms.TextBox txtRequirements;
		private System.Windows.Forms.TextBox txtOrderStatus;
		private System.Windows.Forms.CheckBox cbDateWanted;
		private System.Windows.Forms.Button btnPrint;
		private System.Windows.Forms.DateTimePicker dtpDateStart;
		private System.Windows.Forms.DateTimePicker dtpDateEnd;
		private System.Windows.Forms.Label lblTo;
		private System.Windows.Forms.ColumnHeader colCPRSOrderID;
		private System.Windows.Forms.PrintDialog printDialog1;
		private gov.va.med.vbecs.GUI.controls.PatientInfoToolbar patientInfoToolbar1;
		private System.Windows.Forms.Panel pnlColor;
		private System.Windows.Forms.ColumnHeader colSpecimenUID;
		private gov.va.med.vbecs.GUI.controls.BarcodeTextbox txtSpecimenUID;
		private System.Windows.Forms.PictureBox pictureBox1;
		private System.Windows.Forms.Button btnPrintOrder;
		private System.Windows.Forms.CheckBox cbEmergencyOrder;
		private System.Windows.Forms.Timer timer1;
		private System.Windows.Forms.ColumnHeader colLabOrderNo;
		private System.ComponentModel.IContainer components = null;

		#endregion

		#endregion


		#region constructors

		/// <summary>
		/// Constructor
		/// </summary>
		public FrmPendingOrderSearch()
		{
			this.LockController.LockFunction = Common.LockFunctions.UC016AcceptOrder;

			// This call is required by the Windows Form Designer.
			InitializeComponent();

			using ( new WaitCursor() )
			{
				SetComponentProperties();

				_orders = new BOL.Orders();
				_orders.OrderSelectedEvent += new BOL.Orders.OrderSelectedEventHandler(SetButtons);

				PopulateListView();

				SetHelpFiles();
			}
		}

		/// <summary>
		/// Constructor
		/// </summary>
		/// <param name="cprsOrderNumber"></param>
		public FrmPendingOrderSearch(string cprsOrderNumber) : this()
		{
			//Came from Order Alert icon, with a cprs order number pre-selected...
			foreach(ListViewItem lvi in this.lvSubOrders.Items)
			{
				DataRow dr = (DataRow)lvi.Tag;
				if (dr[Common.VbecsTables.OrderedComponent.CprsOrderNumber].ToString() == cprsOrderNumber)
				{
					lvi.EnsureVisible();
					lvi.Selected = true;
					break;
				}
			}
		}

		#endregion


		#region methods

		private void SetHelpFiles()
		{
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC016.FrmPendingOrderSearch());
			this.SetThisHelpFile(this.btnMSBOS, Common.StrRes.HelpFiles.UC016.FrmPendingOrderSearch_MSBOS());
			this.SetThisHelpFile(this.btnOrderDetails, Common.StrRes.HelpFiles.UC016.FrmPendingOrderSearch_Details());
			this.SetThisHelpFile(this.grpSearchPOL, Common.StrRes.HelpFiles.UC088.FrmPendingOrderSearch());
			this.SetThisHelpFile(this.lvSubOrders, Common.StrRes.HelpFiles.UC016.FrmPendingOrderSearch_POL());
			this.SetThisHelpFile(this.btnReject, Common.StrRes.HelpFiles.UC061.FrmPendingOrderSearch());
		}

		private void SetButtons(object sender, BOL.Orders.SelectOrderEventArgs e)
		{
			bool enableCheckbox = false;
			if (_orders.SelectedOrder is BOL.OrderedComponent)
			{
				enableCheckbox = ((BOL.OrderedComponent) _orders.SelectedOrder).SpecimenRequiredIndicator;
			}


			this.SetOptionButtons();
			
            // CR 3399: changed to class level variable so that I can check it later
            _status = e.AcceptOrderStatus;

			// default values
			this.btnAccept.EnabledButton = false;
			this.ttToolTip.SetToolTip(this.btnAccept, string.Empty);
			//
			this.btnReject.Enabled = false;
			//
			this.txtSpecimenUID.ReadOnly = true;
			this.errError.SetVbecsError(txtSpecimenUID, string.Empty); // **** 508 Compliance ***
			this.cbEmergencyOrder.Enabled = false;
		
			switch (_status)
			{
					// No order is selected
				case Common.AcceptOrderStatus.None:
					this.ttToolTip.SetToolTip(this.btnAccept, Common.StrRes.Tooltips.UC016.SelectOrder().ResString);
					break;
					// Order can be accepted with no further processing
				case Common.AcceptOrderStatus.ReadyForAcceptance:
					if (txtSpecimenUID.Text != string.Empty) 
					{
						this.txtSpecimenUID.ReadOnly = false;
					}
					this.btnAccept.EnabledButton = true;
					this.btnReject.Enabled = true;
					this.cbEmergencyOrder.Enabled = enableCheckbox;
					break;
					// Order has already been accepted or rejected
				case Common.AcceptOrderStatus.AlreadyAcceptedOrRejected:
					break;
					// Order has not been accessioned
				case Common.AcceptOrderStatus.NotAccessioned:
					this.btnReject.Enabled = true;
					this.ttToolTip.SetToolTip(this.btnAccept, Common.StrRes.Tooltips.UC016.NoLabData().ResString);
					break;
					// Order requires a specimen
				case Common.AcceptOrderStatus.RequiresSpecimen:
					this.ttToolTip.SetToolTip(this.btnAccept, Common.StrRes.Tooltips.UC016.SpecimenUIDRequired().ResString);
					this.btnReject.Enabled = true;
					this.txtSpecimenUID.ReadOnly = false; //508 compliance
					this.cbEmergencyOrder.Enabled = enableCheckbox;
					break;
					// Specimen is new (Component orders only)
				case Common.AcceptOrderStatus.SpecimenNotInVBECS:
					this.ttToolTip.SetToolTip(this.btnAccept, Common.StrRes.InfoMsg.UC016.SpecimenUidInvalid().ResString);
					this.btnReject.Enabled = true;
					this.txtSpecimenUID.ReadOnly = false; //508 compliance
					this.errError.SetVbecsError(this.txtSpecimenUID, Common.StrRes.InfoMsg.UC016.SpecimenUidInvalid().ResString); // **** 508 Compliance ***
					this.cbEmergencyOrder.Enabled = enableCheckbox;
					break;
					// Specimen is for different patient
				case Common.AcceptOrderStatus.WrongSpecimen:
					this.ttToolTip.SetToolTip(this.btnAccept, Common.StrRes.InfoMsg.UC016.SpecimenUidInvalid().ResString);
					this.btnReject.Enabled = true;
					this.txtSpecimenUID.ReadOnly = false; //508 compliance
					this.errError.SetVbecsError(this.txtSpecimenUID, Common.StrRes.InfoMsg.UC016.SpecimenUidInvalid().ResString); // **** 508 Compliance ***
					this.cbEmergencyOrder.Enabled = enableCheckbox;
					break;
					// Specimen is not maintainable
				case Common.AcceptOrderStatus.SpecimenNotMaintainable:
					this.ttToolTip.SetToolTip(this.btnAccept, Common.StrRes.InfoMsg.UC016.SpecimenNonMaintainable().ResString);
					this.btnReject.Enabled = true;
					this.txtSpecimenUID.ReadOnly = false; //508 compliance
					this.errError.SetVbecsError(this.txtSpecimenUID, Common.StrRes.InfoMsg.UC016.SpecimenNonMaintainable().ResString); // **** 508 Compliance ***
					this.cbEmergencyOrder.Enabled = enableCheckbox;
					break;
					// Specimen has broken rules
				case Common.AcceptOrderStatus.SpecimenHasBrokenRules:
					this.btnReject.Enabled = true;
					this.ttToolTip.SetToolTip(this.btnAccept, Common.StrRes.InfoMsg.UC016.SpecimenNeedsCorrection().ResString);
					this.txtSpecimenUID.ReadOnly = false; //508 compliance
					UpdateSpecimen();
					this.cbEmergencyOrder.Enabled = enableCheckbox;
					break;
					// Specimen is new
				case Common.AcceptOrderStatus.SpecimenRequiresUpdate:
					this.btnReject.Enabled = true;
					this.ttToolTip.SetToolTip(this.btnAccept, Common.StrRes.Tooltips.UC016.SpecimenDetailsRequired().ResString);
					this.txtSpecimenUID.ReadOnly = false; //508 compliance
					UpdateSpecimen();
					break;
					// No specimen like this exists
				case Common.AcceptOrderStatus.SpecimenUidInvalid:
					this.ttToolTip.SetToolTip(this.btnAccept, Common.StrRes.InfoMsg.UC016.SpecimenUidInvalid().ResString);
					this.btnReject.Enabled = true;
					this.txtSpecimenUID.ReadOnly = false; //508 compliance
					this.errError.SetVbecsError(this.txtSpecimenUID, Common.StrRes.InfoMsg.UC016.SpecimenUidInvalid().ResString); // **** 508 Compliance ***
					break;
					// No lab data for specimen
				case Common.AcceptOrderStatus.NoLabDataForSpecimen:
					this.ttToolTip.SetToolTip(this.btnAccept, Common.StrRes.Tooltips.UC016.NoLabData().ResString);
					this.txtSpecimenUID.ReadOnly = false; //508 compliance
					this.errError.SetVbecsError(this.txtSpecimenUID, Common.StrRes.Tooltips.UC016.NoLabData().ResString); // **** 508 Compliance ***
					break;
					// Wrong order
				case Common.AcceptOrderStatus.SpecimenMismatch:
					this.ttToolTip.SetToolTip(this.btnAccept, Common.StrRes.Tooltips.UC016.MismatchedSpecimen().ResString);
					this.txtSpecimenUID.ReadOnly = false; //508 compliance
					this.errError.SetVbecsError(this.txtSpecimenUID, Common.StrRes.Tooltips.UC016.MismatchedSpecimen().ResString); // **** 508 Compliance ***
					break;
			}
		}


		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(FrmPendingOrderSearch));
			this.grpImage2 = new System.Windows.Forms.GroupBox();
			this.picPOL = new System.Windows.Forms.PictureBox();
			this.btnCancel = new System.Windows.Forms.Button();
			this.helpProvider1 = new System.Windows.Forms.HelpProvider();
			this.toolTip1 = new System.Windows.Forms.ToolTip(this.components);
			this.btnMSBOS = new System.Windows.Forms.Button();
			this.imageList1 = new System.Windows.Forms.ImageList(this.components);
			this.btnAutoDirUnits = new System.Windows.Forms.Button();
			this.btnOrderDetails = new System.Windows.Forms.Button();
			this.grpSearchPOL = new System.Windows.Forms.GroupBox();
			this.dtpDateEnd = new System.Windows.Forms.DateTimePicker();
			this.dtpDateStart = new System.Windows.Forms.DateTimePicker();
			this.cbDateWanted = new System.Windows.Forms.CheckBox();
			this.btnClear = new System.Windows.Forms.Button();
			this.btnSearch = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.txtOrder = new System.Windows.Forms.TextBox();
			this.txtPatient = new System.Windows.Forms.TextBox();
			this.txtSpecimen = new gov.va.med.vbecs.GUI.controls.BarcodeTextbox(this.components);
			this.pictureBox4 = new System.Windows.Forms.PictureBox();
			this.lblSearchOrder = new System.Windows.Forms.Label();
			this.lblSearchPatient = new System.Windows.Forms.Label();
			this.lblSearchSpecimen = new System.Windows.Forms.Label();
			this.lblTo = new System.Windows.Forms.Label();
			this.groupBox2 = new System.Windows.Forms.GroupBox();
			this.pnlPOL = new System.Windows.Forms.Panel();
			this.lvSubOrders = new System.Windows.Forms.ListView();
			this.colIcon = new System.Windows.Forms.ColumnHeader();
			this.colPatientName = new System.Windows.Forms.ColumnHeader();
			this.colPatientID = new System.Windows.Forms.ColumnHeader();
			this.colSpecimenUID = new System.Windows.Forms.ColumnHeader();
			this.colLabOrderNo = new System.Windows.Forms.ColumnHeader();
			this.colUrgency = new System.Windows.Forms.ColumnHeader();
			this.colSpecimenStatus = new System.Windows.Forms.ColumnHeader();
			this.colProcedure = new System.Windows.Forms.ColumnHeader();
			this.colProvider = new System.Windows.Forms.ColumnHeader();
			this.colPatientLocation = new System.Windows.Forms.ColumnHeader();
			this.colDateReceived = new System.Windows.Forms.ColumnHeader();
			this.colDateWanted = new System.Windows.Forms.ColumnHeader();
			this.colCPRSOrderID = new System.Windows.Forms.ColumnHeader();
			this.btnPrint = new System.Windows.Forms.Button();
			this.splitter2 = new System.Windows.Forms.Splitter();
			this.pnlSelectedOrder = new System.Windows.Forms.Panel();
			this.splitter1 = new System.Windows.Forms.Splitter();
			this.pnlSelectedOrderDetails = new System.Windows.Forms.Panel();
			this.cbEmergencyOrder = new System.Windows.Forms.CheckBox();
			this.pictureBox1 = new System.Windows.Forms.PictureBox();
			this.txtSpecimenUID = new gov.va.med.vbecs.GUI.controls.BarcodeTextbox(this.components);
			this.txtLabOrderID = new System.Windows.Forms.TextBox();
			this.label1 = new System.Windows.Forms.Label();
			this.btnReject = new System.Windows.Forms.Button();
			this.btnAccept = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.txtQuantity = new System.Windows.Forms.TextBox();
			this.label5 = new System.Windows.Forms.Label();
			this.txtRequirements = new System.Windows.Forms.TextBox();
			this.label3 = new System.Windows.Forms.Label();
			this.txtComments = new System.Windows.Forms.TextBox();
			this.lblComments = new System.Windows.Forms.Label();
			this.lblSpecimen = new System.Windows.Forms.Label();
			this.txtProcedure = new System.Windows.Forms.TextBox();
			this.lblProcedure = new System.Windows.Forms.Label();
			this.txtOrderStatus = new System.Windows.Forms.TextBox();
			this.txtPatientLocation = new System.Windows.Forms.TextBox();
			this.txtABORH = new System.Windows.Forms.TextBox();
			this.txtPatientName = new System.Windows.Forms.TextBox();
			this.txtPhysician = new System.Windows.Forms.TextBox();
			this.txtSSN = new System.Windows.Forms.TextBox();
			this.lblDateWanted = new System.Windows.Forms.Label();
			this.lblPatientLocation = new System.Windows.Forms.Label();
			this.lblPhysician = new System.Windows.Forms.Label();
			this.label2 = new System.Windows.Forms.Label();
			this.lblPatientID = new System.Windows.Forms.Label();
			this.lblSelectedPatient = new System.Windows.Forms.Label();
			this.pnlSelectedOrderHeader = new System.Windows.Forms.Panel();
			this.pnlColor = new System.Windows.Forms.Panel();
			this.patientInfoToolbar1 = new gov.va.med.vbecs.GUI.controls.PatientInfoToolbar();
			this.pictureBox2 = new System.Windows.Forms.PictureBox();
			this.label6 = new System.Windows.Forms.Label();
			this.grpSplit = new System.Windows.Forms.GroupBox();
			this.pnlTreeView = new System.Windows.Forms.Panel();
			this.pnpPOL = new System.Windows.Forms.Panel();
			this.tvPOL = new System.Windows.Forms.TreeView();
			this.btnPrintOrder = new System.Windows.Forms.Button();
			this.pnlOrderGroupHeader = new System.Windows.Forms.Panel();
			this.pictureBox8 = new System.Windows.Forms.PictureBox();
			this.lblOrderGroup = new System.Windows.Forms.Label();
			this.printDialog1 = new System.Windows.Forms.PrintDialog();
			this.timer1 = new System.Windows.Forms.Timer(this.components);
			this.grpImage2.SuspendLayout();
			this.grpSearchPOL.SuspendLayout();
			this.groupBox2.SuspendLayout();
			this.pnlPOL.SuspendLayout();
			this.pnlSelectedOrder.SuspendLayout();
			this.pnlSelectedOrderDetails.SuspendLayout();
			this.pnlSelectedOrderHeader.SuspendLayout();
			this.pnlColor.SuspendLayout();
			this.pnlTreeView.SuspendLayout();
			this.pnpPOL.SuspendLayout();
			this.pnlOrderGroupHeader.SuspendLayout();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(742, 30);
			this.vbecsLogo1.TabIndex = 4;
			this.vbecsLogo1.Title = "Accept Orders";
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Location = new System.Drawing.Point(0, 450);
			this.lblRequiredField.Name = "lblRequiredField";
			this.lblRequiredField.TabIndex = 6;
			// 
			// grpImage2
			// 
			this.grpImage2.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.grpImage2.Controls.Add(this.picPOL);
			this.grpImage2.Location = new System.Drawing.Point(2, 32);
			this.grpImage2.Name = "grpImage2";
			this.grpImage2.Size = new System.Drawing.Size(38, 399);
			this.grpImage2.TabIndex = 5;
			this.grpImage2.TabStop = false;
			// 
			// picPOL
			// 
			this.picPOL.Image = ((System.Drawing.Image)(resources.GetObject("picPOL.Image")));
			this.picPOL.Location = new System.Drawing.Point(4, 8);
			this.picPOL.Name = "picPOL";
			this.picPOL.Size = new System.Drawing.Size(32, 32);
			this.picPOL.SizeMode = System.Windows.Forms.PictureBoxSizeMode.StretchImage;
			this.picPOL.TabIndex = 2;
			this.picPOL.TabStop = false;
			// 
			// btnCancel
			// 
			this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.Location = new System.Drawing.Point(660, 439);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.TabIndex = 28;
			this.btnCancel.Text = "&Close";
			this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
			// 
			// btnMSBOS
			// 
			this.btnMSBOS.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.btnMSBOS.BackColor = System.Drawing.SystemColors.Control;
			this.btnMSBOS.Enabled = false;
			this.btnMSBOS.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
			this.hlphelpChm.SetHelpKeyword(this.btnMSBOS, "Accept_Orders.htm");
			this.hlphelpChm.SetHelpNavigator(this.btnMSBOS, System.Windows.Forms.HelpNavigator.Topic);
			this.btnMSBOS.ImageIndex = 5;
			this.btnMSBOS.ImageList = this.imageList1;
			this.btnMSBOS.Location = new System.Drawing.Point(26, 0);
			this.btnMSBOS.Name = "btnMSBOS";
			this.hlphelpChm.SetShowHelp(this.btnMSBOS, true);
			this.btnMSBOS.Size = new System.Drawing.Size(24, 20);
			this.btnMSBOS.TabIndex = 1;
			this.toolTip1.SetToolTip(this.btnMSBOS, "Evaluate MSBOS");
			this.btnMSBOS.Click += new System.EventHandler(this.btnMSBOS_Click);
			// 
			// imageList1
			// 
			this.imageList1.ImageSize = new System.Drawing.Size(16, 16);
			this.imageList1.ImageStream = ((System.Windows.Forms.ImageListStreamer)(resources.GetObject("imageList1.ImageStream")));
			this.imageList1.TransparentColor = System.Drawing.Color.Transparent;
			// 
			// btnAutoDirUnits
			// 
			this.btnAutoDirUnits.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.btnAutoDirUnits.BackColor = System.Drawing.SystemColors.Control;
			this.btnAutoDirUnits.Enabled = false;
			this.btnAutoDirUnits.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
			this.hlphelpChm.SetHelpNavigator(this.btnAutoDirUnits, System.Windows.Forms.HelpNavigator.Topic);
			this.btnAutoDirUnits.ImageIndex = 6;
			this.btnAutoDirUnits.ImageList = this.imageList1;
			this.btnAutoDirUnits.Location = new System.Drawing.Point(53, 0);
			this.btnAutoDirUnits.Name = "btnAutoDirUnits";
			this.hlphelpChm.SetShowHelp(this.btnAutoDirUnits, true);
			this.btnAutoDirUnits.Size = new System.Drawing.Size(24, 20);
			this.btnAutoDirUnits.TabIndex = 2;
			this.toolTip1.SetToolTip(this.btnAutoDirUnits, "Autologous/Directed Units");
			this.btnAutoDirUnits.Click += new System.EventHandler(this.btnAutoDirUnits_Click);
			// 
			// btnOrderDetails
			// 
			this.btnOrderDetails.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.btnOrderDetails.BackColor = System.Drawing.SystemColors.Control;
			this.btnOrderDetails.Enabled = false;
			this.btnOrderDetails.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
			this.hlphelpChm.SetHelpKeyword(this.btnOrderDetails, "Orders_UC_16.htm#OrderDetails");
			this.hlphelpChm.SetHelpNavigator(this.btnOrderDetails, System.Windows.Forms.HelpNavigator.Topic);
			this.btnOrderDetails.ImageIndex = 1;
			this.btnOrderDetails.ImageList = this.imageList1;
			this.btnOrderDetails.Location = new System.Drawing.Point(0, 0);
			this.btnOrderDetails.Name = "btnOrderDetails";
			this.hlphelpChm.SetShowHelp(this.btnOrderDetails, true);
			this.btnOrderDetails.Size = new System.Drawing.Size(24, 20);
			this.btnOrderDetails.TabIndex = 0;
			this.toolTip1.SetToolTip(this.btnOrderDetails, "Order Details");
			this.btnOrderDetails.Click += new System.EventHandler(this.btnOrderDetails_Click);
			// 
			// grpSearchPOL
			// 
			this.grpSearchPOL.AccessibleDescription = "Pending Order List Search Criteria";
			this.grpSearchPOL.AccessibleName = "Pending Order List Search Criteria";
			this.grpSearchPOL.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpSearchPOL.Controls.Add(this.dtpDateEnd);
			this.grpSearchPOL.Controls.Add(this.dtpDateStart);
			this.grpSearchPOL.Controls.Add(this.cbDateWanted);
			this.grpSearchPOL.Controls.Add(this.btnClear);
			this.grpSearchPOL.Controls.Add(this.btnSearch);
			this.grpSearchPOL.Controls.Add(this.txtOrder);
			this.grpSearchPOL.Controls.Add(this.txtPatient);
			this.grpSearchPOL.Controls.Add(this.txtSpecimen);
			this.grpSearchPOL.Controls.Add(this.pictureBox4);
			this.grpSearchPOL.Controls.Add(this.lblSearchOrder);
			this.grpSearchPOL.Controls.Add(this.lblSearchPatient);
			this.grpSearchPOL.Controls.Add(this.lblSearchSpecimen);
			this.grpSearchPOL.Controls.Add(this.lblTo);
			this.hlphelpChm.SetHelpKeyword(this.grpSearchPOL, "Orders_UC_88.htm");
			this.hlphelpChm.SetHelpNavigator(this.grpSearchPOL, System.Windows.Forms.HelpNavigator.Topic);
			this.grpSearchPOL.Location = new System.Drawing.Point(44, 32);
			this.grpSearchPOL.Name = "grpSearchPOL";
			this.hlphelpChm.SetShowHelp(this.grpSearchPOL, true);
			this.grpSearchPOL.Size = new System.Drawing.Size(692, 64);
			this.grpSearchPOL.TabIndex = 0;
			this.grpSearchPOL.TabStop = false;
			this.grpSearchPOL.Text = "Pending Order List Search Criteria";
			// 
			// dtpDateEnd
			// 
			this.dtpDateEnd.AccessibleDescription = "Date Wanted To";
			this.dtpDateEnd.AccessibleName = "Date Wanted To";
			this.dtpDateEnd.CustomFormat = "";
			this.dtpDateEnd.Enabled = false;
			this.dtpDateEnd.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
			this.dtpDateEnd.Location = new System.Drawing.Point(208, 40);
			this.dtpDateEnd.Name = "dtpDateEnd";
			this.dtpDateEnd.Size = new System.Drawing.Size(80, 20);
			this.dtpDateEnd.TabIndex = 4;
			// 
			// dtpDateStart
			// 
			this.dtpDateStart.AccessibleDescription = "Date Wanted Start";
			this.dtpDateStart.AccessibleName = "Date Wanted Start";
			this.dtpDateStart.CustomFormat = "";
			this.dtpDateStart.Enabled = false;
			this.dtpDateStart.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
			this.dtpDateStart.Location = new System.Drawing.Point(104, 40);
			this.dtpDateStart.Name = "dtpDateStart";
			this.dtpDateStart.Size = new System.Drawing.Size(80, 20);
			this.dtpDateStart.TabIndex = 3;
			this.dtpDateStart.Value = new System.DateTime(2003, 5, 22, 0, 0, 0, 0);
			// 
			// cbDateWanted
			// 
			this.cbDateWanted.AccessibleDescription = "Date Wanted";
			this.cbDateWanted.AccessibleName = "Date Wanted";
			this.cbDateWanted.Location = new System.Drawing.Point(16, 40);
			this.cbDateWanted.Name = "cbDateWanted";
			this.cbDateWanted.Size = new System.Drawing.Size(100, 20);
			this.cbDateWanted.TabIndex = 2;
			this.cbDateWanted.Text = "&Date Wanted";
			this.cbDateWanted.CheckedChanged += new System.EventHandler(this.SearchStateChanged);
			// 
			// btnClear
			// 
			this.btnClear.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnClear.Location = new System.Drawing.Point(612, 36);
			this.btnClear.Name = "btnClear";
			this.btnClear.TabIndex = 8;
			this.btnClear.Text = "C&lear";
			this.btnClear.Click += new System.EventHandler(this.btnClear_Click);
			// 
			// btnSearch
			// 
			this.btnSearch.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnSearch.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnSearch.Image = ((System.Drawing.Image)(resources.GetObject("btnSearch.Image")));
			this.btnSearch.Location = new System.Drawing.Point(532, 36);
			this.btnSearch.Name = "btnSearch";
			this.btnSearch.Size = new System.Drawing.Size(75, 23);
			this.btnSearch.TabIndex = 7;
			this.btnSearch.Click += new System.EventHandler(this.btnSearch_Click);
			// 
			// txtOrder
			// 
			this.txtOrder.AccessibleDescription = "Lab Order Number";
			this.txtOrder.AccessibleName = "Lab Order Number";
			this.txtOrder.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtOrder.Location = new System.Drawing.Point(380, 40);
			this.txtOrder.MaxLength = 20;
			this.txtOrder.Name = "txtOrder";
			this.txtOrder.Size = new System.Drawing.Size(132, 20);
			this.txtOrder.TabIndex = 6;
			this.txtOrder.Text = "";
			this.txtOrder.TextChanged += new System.EventHandler(this.SearchStateChanged);
			// 
			// txtPatient
			// 
			this.txtPatient.AccessibleDescription = "Patient";
			this.txtPatient.AccessibleName = "Patient";
			this.txtPatient.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtPatient.Location = new System.Drawing.Point(380, 16);
			this.txtPatient.MaxLength = 30;
			this.txtPatient.Name = "txtPatient";
			this.txtPatient.Size = new System.Drawing.Size(132, 20);
			this.txtPatient.TabIndex = 5;
			this.txtPatient.Text = "";
			this.txtPatient.TextChanged += new System.EventHandler(this.SearchStateChanged);
			// 
			// txtSpecimen
			// 
			this.txtSpecimen.AccessibleDescription = "Specimen U I D";
			this.txtSpecimen.AccessibleName = "Specimen U I D";
			this.txtSpecimen.Barcode = false;
			this.txtSpecimen.BarcodeType = gov.va.med.vbecs.Common.BarcodeType.Codabar;
			this.txtSpecimen.Location = new System.Drawing.Point(104, 16);
			this.txtSpecimen.MaxLength = 15;
			this.txtSpecimen.Name = "txtSpecimen";
			this.txtSpecimen.Size = new System.Drawing.Size(184, 20);
			this.txtSpecimen.TabIndex = 1;
			this.txtSpecimen.Text = "";
			this.txtSpecimen.Leave += new System.EventHandler(this.txtSpecimen_Leave);
			this.txtSpecimen.TextChanged += new System.EventHandler(this.SearchStateChanged);
			// 
			// pictureBox4
			// 
			this.pictureBox4.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox4.Image")));
			this.pictureBox4.Location = new System.Drawing.Point(10, 20);
			this.pictureBox4.Name = "pictureBox4";
			this.pictureBox4.Size = new System.Drawing.Size(20, 20);
			this.pictureBox4.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.pictureBox4.TabIndex = 56;
			this.pictureBox4.TabStop = false;
			// 
			// lblSearchOrder
			// 
			this.lblSearchOrder.Location = new System.Drawing.Point(304, 40);
			this.lblSearchOrder.Name = "lblSearchOrder";
			this.lblSearchOrder.Size = new System.Drawing.Size(84, 20);
			this.lblSearchOrder.TabIndex = 8;
			this.lblSearchOrder.Text = "Lab Order No.";
			this.lblSearchOrder.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblSearchPatient
			// 
			this.lblSearchPatient.Location = new System.Drawing.Point(304, 16);
			this.lblSearchPatient.Name = "lblSearchPatient";
			this.lblSearchPatient.Size = new System.Drawing.Size(80, 23);
			this.lblSearchPatient.TabIndex = 6;
			this.lblSearchPatient.Text = "Patient";
			this.lblSearchPatient.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblSearchSpecimen
			// 
			this.lblSearchSpecimen.Location = new System.Drawing.Point(32, 16);
			this.lblSearchSpecimen.Name = "lblSearchSpecimen";
			this.lblSearchSpecimen.Size = new System.Drawing.Size(80, 23);
			this.lblSearchSpecimen.TabIndex = 0;
			this.lblSearchSpecimen.Text = "Specimen UID";
			this.lblSearchSpecimen.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblTo
			// 
			this.lblTo.Location = new System.Drawing.Point(192, 40);
			this.lblTo.Name = "lblTo";
			this.lblTo.Size = new System.Drawing.Size(20, 20);
			this.lblTo.TabIndex = 4;
			this.lblTo.Text = "To";
			this.lblTo.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// groupBox2
			// 
			this.groupBox2.AccessibleDescription = "Pending Order List";
			this.groupBox2.AccessibleName = "Pending Order List";
			this.groupBox2.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.groupBox2.Controls.Add(this.pnlPOL);
			this.groupBox2.Controls.Add(this.splitter2);
			this.groupBox2.Location = new System.Drawing.Point(44, 96);
			this.groupBox2.Name = "groupBox2";
			this.groupBox2.Size = new System.Drawing.Size(692, 123);
			this.groupBox2.TabIndex = 9;
			this.groupBox2.TabStop = false;
			this.groupBox2.Text = "Pending Order List";
			// 
			// pnlPOL
			// 
			this.pnlPOL.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.pnlPOL.BackColor = System.Drawing.SystemColors.Control;
			this.pnlPOL.Controls.Add(this.lvSubOrders);
			this.pnlPOL.Controls.Add(this.btnPrint);
			this.pnlPOL.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.pnlPOL.Location = new System.Drawing.Point(3, 16);
			this.pnlPOL.Name = "pnlPOL";
			this.pnlPOL.Size = new System.Drawing.Size(686, 103);
			this.pnlPOL.TabIndex = 9;
			this.pnlPOL.TabStop = true;
			// 
			// lvSubOrders
			// 
			this.lvSubOrders.AccessibleDescription = "Pending Order List";
			this.lvSubOrders.AccessibleName = "Pending Order List";
			this.lvSubOrders.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lvSubOrders.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																						  this.colIcon,
																						  this.colPatientName,
																						  this.colPatientID,
																						  this.colSpecimenUID,
																						  this.colLabOrderNo,
																						  this.colUrgency,
																						  this.colSpecimenStatus,
																						  this.colProcedure,
																						  this.colProvider,
																						  this.colPatientLocation,
																						  this.colDateReceived,
																						  this.colDateWanted,
																						  this.colCPRSOrderID});
			this.lvSubOrders.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.lvSubOrders.FullRowSelect = true;
			this.hlphelpChm.SetHelpKeyword(this.lvSubOrders, "Orders_UC_16.htm#PendingOrderList");
			this.hlphelpChm.SetHelpNavigator(this.lvSubOrders, System.Windows.Forms.HelpNavigator.Topic);
			this.lvSubOrders.HideSelection = false;
			this.lvSubOrders.Location = new System.Drawing.Point(0, 0);
			this.lvSubOrders.MultiSelect = false;
			this.lvSubOrders.Name = "lvSubOrders";
			this.hlphelpChm.SetShowHelp(this.lvSubOrders, true);
			this.lvSubOrders.Size = new System.Drawing.Size(684, 75);
			this.lvSubOrders.SmallImageList = this.imageList1;
			this.lvSubOrders.TabIndex = 10;
			this.lvSubOrders.View = System.Windows.Forms.View.Details;
			this.lvSubOrders.ColumnClick += new System.Windows.Forms.ColumnClickEventHandler(this.lvSubOrders_ColumnClick);
			this.lvSubOrders.SelectedIndexChanged += new System.EventHandler(this.lvSubOrders_SelectedIndexChanged);
			// 
			// colIcon
			// 
			this.colIcon.Text = "";
			this.colIcon.Width = 20;
			// 
			// colPatientName
			// 
			this.colPatientName.Text = "Patient Name";
			this.colPatientName.Width = 100;
			// 
			// colPatientID
			// 
			this.colPatientID.Text = "Patient ID";
			this.colPatientID.Width = 80;
			// 
			// colSpecimenUID
			// 
			this.colSpecimenUID.Text = "Specimen UID";
			this.colSpecimenUID.Width = 85;
			// 
			// colLabOrderNo
			// 
			this.colLabOrderNo.Text = "Lab Order No.";
			this.colLabOrderNo.Width = 80;
			// 
			// colUrgency
			// 
			this.colUrgency.Text = "Urgency";
			this.colUrgency.Width = 55;
			// 
			// colSpecimenStatus
			// 
			this.colSpecimenStatus.Text = "Specimen";
			// 
			// colProcedure
			// 
			this.colProcedure.Text = "Request";
			this.colProcedure.Width = 90;
			// 
			// colProvider
			// 
			this.colProvider.Text = "Ordered By";
			this.colProvider.Width = 105;
			// 
			// colPatientLocation
			// 
			this.colPatientLocation.Text = "Patient Location";
			this.colPatientLocation.Width = 85;
			// 
			// colDateReceived
			// 
			this.colDateReceived.Text = "Received";
			this.colDateReceived.Width = 80;
			// 
			// colDateWanted
			// 
			this.colDateWanted.Text = "Wanted";
			this.colDateWanted.Width = 80;
			// 
			// colCPRSOrderID
			// 
			this.colCPRSOrderID.Text = "CPRS Order ID";
			this.colCPRSOrderID.Width = 80;
			// 
			// btnPrint
			// 
			this.btnPrint.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnPrint.ImageAlign = System.Drawing.ContentAlignment.MiddleLeft;
			this.btnPrint.ImageIndex = 3;
			this.btnPrint.ImageList = this.imageList1;
			this.btnPrint.Location = new System.Drawing.Point(608, 78);
			this.btnPrint.Name = "btnPrint";
			this.btnPrint.TabIndex = 10;
			this.btnPrint.Text = "&Print";
			this.btnPrint.Click += new System.EventHandler(this.btnPrint_Click);
			// 
			// splitter2
			// 
			this.splitter2.Dock = System.Windows.Forms.DockStyle.Top;
			this.splitter2.Location = new System.Drawing.Point(3, 16);
			this.splitter2.Name = "splitter2";
			this.splitter2.Size = new System.Drawing.Size(686, 3);
			this.splitter2.TabIndex = 5;
			this.splitter2.TabStop = false;
			// 
			// pnlSelectedOrder
			// 
			this.pnlSelectedOrder.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.pnlSelectedOrder.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
			this.pnlSelectedOrder.Controls.Add(this.splitter1);
			this.pnlSelectedOrder.Controls.Add(this.pnlSelectedOrderDetails);
			this.pnlSelectedOrder.Controls.Add(this.pnlTreeView);
			this.pnlSelectedOrder.Location = new System.Drawing.Point(44, 223);
			this.pnlSelectedOrder.Name = "pnlSelectedOrder";
			this.pnlSelectedOrder.Size = new System.Drawing.Size(692, 208);
			this.pnlSelectedOrder.TabIndex = 10;
			// 
			// splitter1
			// 
			this.splitter1.Location = new System.Drawing.Point(136, 0);
			this.splitter1.Name = "splitter1";
			this.splitter1.Size = new System.Drawing.Size(3, 206);
			this.splitter1.TabIndex = 1;
			this.splitter1.TabStop = false;
			// 
			// pnlSelectedOrderDetails
			// 
			this.pnlSelectedOrderDetails.Controls.Add(this.cbEmergencyOrder);
			this.pnlSelectedOrderDetails.Controls.Add(this.pictureBox1);
			this.pnlSelectedOrderDetails.Controls.Add(this.txtSpecimenUID);
			this.pnlSelectedOrderDetails.Controls.Add(this.txtLabOrderID);
			this.pnlSelectedOrderDetails.Controls.Add(this.label1);
			this.pnlSelectedOrderDetails.Controls.Add(this.btnReject);
			this.pnlSelectedOrderDetails.Controls.Add(this.btnAccept);
			this.pnlSelectedOrderDetails.Controls.Add(this.txtQuantity);
			this.pnlSelectedOrderDetails.Controls.Add(this.label5);
			this.pnlSelectedOrderDetails.Controls.Add(this.txtRequirements);
			this.pnlSelectedOrderDetails.Controls.Add(this.label3);
			this.pnlSelectedOrderDetails.Controls.Add(this.txtComments);
			this.pnlSelectedOrderDetails.Controls.Add(this.lblComments);
			this.pnlSelectedOrderDetails.Controls.Add(this.lblSpecimen);
			this.pnlSelectedOrderDetails.Controls.Add(this.txtProcedure);
			this.pnlSelectedOrderDetails.Controls.Add(this.lblProcedure);
			this.pnlSelectedOrderDetails.Controls.Add(this.txtOrderStatus);
			this.pnlSelectedOrderDetails.Controls.Add(this.txtPatientLocation);
			this.pnlSelectedOrderDetails.Controls.Add(this.txtABORH);
			this.pnlSelectedOrderDetails.Controls.Add(this.txtPatientName);
			this.pnlSelectedOrderDetails.Controls.Add(this.txtPhysician);
			this.pnlSelectedOrderDetails.Controls.Add(this.txtSSN);
			this.pnlSelectedOrderDetails.Controls.Add(this.lblDateWanted);
			this.pnlSelectedOrderDetails.Controls.Add(this.lblPatientLocation);
			this.pnlSelectedOrderDetails.Controls.Add(this.lblPhysician);
			this.pnlSelectedOrderDetails.Controls.Add(this.label2);
			this.pnlSelectedOrderDetails.Controls.Add(this.lblPatientID);
			this.pnlSelectedOrderDetails.Controls.Add(this.lblSelectedPatient);
			this.pnlSelectedOrderDetails.Controls.Add(this.pnlSelectedOrderHeader);
			this.pnlSelectedOrderDetails.Controls.Add(this.grpSplit);
			this.pnlSelectedOrderDetails.Dock = System.Windows.Forms.DockStyle.Fill;
			this.pnlSelectedOrderDetails.Location = new System.Drawing.Point(136, 0);
			this.pnlSelectedOrderDetails.Name = "pnlSelectedOrderDetails";
			this.pnlSelectedOrderDetails.Size = new System.Drawing.Size(554, 206);
			this.pnlSelectedOrderDetails.TabIndex = 2;
			// 
			// cbEmergencyOrder
			// 
			this.cbEmergencyOrder.AccessibleDescription = "Emergency Order";
			this.cbEmergencyOrder.AccessibleName = "Emergency Order";
			this.cbEmergencyOrder.CheckAlign = System.Drawing.ContentAlignment.MiddleRight;
			this.cbEmergencyOrder.Enabled = false;
			this.cbEmergencyOrder.Location = new System.Drawing.Point(4, 172);
			this.cbEmergencyOrder.Name = "cbEmergencyOrder";
			this.hlphelpChm.SetShowHelp(this.cbEmergencyOrder, false);
			this.cbEmergencyOrder.Size = new System.Drawing.Size(120, 24);
			this.cbEmergencyOrder.TabIndex = 19;
			this.cbEmergencyOrder.Text = "&Emergency Order";
			this.cbEmergencyOrder.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			this.cbEmergencyOrder.CheckedChanged += new System.EventHandler(this.cbEmergencyOrder_CheckedChanged);
			// 
			// pictureBox1
			// 
			this.pictureBox1.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox1.Image")));
			this.pictureBox1.Location = new System.Drawing.Point(4, 148);
			this.pictureBox1.Name = "pictureBox1";
			this.pictureBox1.Size = new System.Drawing.Size(20, 20);
			this.pictureBox1.TabIndex = 69;
			this.pictureBox1.TabStop = false;
			// 
			// txtSpecimenUID
			// 
			this.txtSpecimenUID.AccessibleDescription = "Specimen U I D";
			this.txtSpecimenUID.AccessibleName = "Specimen U I D";
			this.txtSpecimenUID.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtSpecimenUID.Barcode = false;
			this.txtSpecimenUID.BarcodeType = gov.va.med.vbecs.Common.BarcodeType.Codabar;
			this.txtSpecimenUID.Location = new System.Drawing.Point(110, 148);
			this.txtSpecimenUID.MaxLength = 15;
			this.txtSpecimenUID.Name = "txtSpecimenUID";
			this.txtSpecimenUID.ReadOnly = true;
			this.txtSpecimenUID.Size = new System.Drawing.Size(174, 20);
			this.txtSpecimenUID.TabIndex = 18;
			this.txtSpecimenUID.Text = "";
			this.txtSpecimenUID.TextChanged += new System.EventHandler(this.txtSpecimenUID_TextChanged);
			// 
			// txtLabOrderID
			// 
			this.txtLabOrderID.AccessibleDescription = "Lab Order Number";
			this.txtLabOrderID.AccessibleName = "Lab Order Number";
			this.txtLabOrderID.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.txtLabOrderID.Location = new System.Drawing.Point(376, 76);
			this.txtLabOrderID.Name = "txtLabOrderID";
			this.txtLabOrderID.ReadOnly = true;
			this.txtLabOrderID.Size = new System.Drawing.Size(172, 20);
			this.txtLabOrderID.TabIndex = 22;
			this.txtLabOrderID.Text = "";
			// 
			// label1
			// 
			this.label1.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.label1.Location = new System.Drawing.Point(296, 76);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(88, 20);
			this.label1.TabIndex = 16;
			this.label1.Text = "Lab Order No.";
			this.label1.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// btnReject
			// 
			this.btnReject.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnReject.Enabled = false;
			this.btnReject.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.hlphelpChm.SetHelpKeyword(this.btnReject, "Orders_UC_61.htm");
			this.hlphelpChm.SetHelpNavigator(this.btnReject, System.Windows.Forms.HelpNavigator.Topic);
			this.btnReject.Image = ((System.Drawing.Image)(resources.GetObject("btnReject.Image")));
			this.btnReject.ImageAlign = System.Drawing.ContentAlignment.MiddleLeft;
			this.btnReject.Location = new System.Drawing.Point(464, 177);
			this.btnReject.Name = "btnReject";
			this.hlphelpChm.SetShowHelp(this.btnReject, true);
			this.btnReject.Size = new System.Drawing.Size(84, 23);
			this.btnReject.TabIndex = 27;
			this.btnReject.Text = "&Reject";
			this.btnReject.Click += new System.EventHandler(this.btnReject_Click);
			// 
			// btnAccept
			// 
			this.btnAccept.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnAccept.EnabledButton = false;
			this.btnAccept.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnAccept.Image = ((System.Drawing.Image)(resources.GetObject("btnAccept.Image")));
			this.btnAccept.Location = new System.Drawing.Point(376, 177);
			this.btnAccept.Name = "btnAccept";
			this.btnAccept.Size = new System.Drawing.Size(84, 23);
			this.btnAccept.TabIndex = 26;
			this.btnAccept.Click += new System.EventHandler(this.btnAccept_Click);
			// 
			// txtQuantity
			// 
			this.txtQuantity.AccessibleDescription = "Quantity";
			this.txtQuantity.AccessibleName = "Quantity";
			this.txtQuantity.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.txtQuantity.Location = new System.Drawing.Point(376, 148);
			this.txtQuantity.Name = "txtQuantity";
			this.txtQuantity.ReadOnly = true;
			this.txtQuantity.Size = new System.Drawing.Size(172, 20);
			this.txtQuantity.TabIndex = 25;
			this.txtQuantity.Text = "";
			// 
			// label5
			// 
			this.label5.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.label5.Location = new System.Drawing.Point(296, 148);
			this.label5.Name = "label5";
			this.label5.Size = new System.Drawing.Size(88, 20);
			this.label5.TabIndex = 22;
			this.label5.Text = "Quantity";
			this.label5.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtRequirements
			// 
			this.txtRequirements.AccessibleDescription = "Requirements";
			this.txtRequirements.AccessibleName = "Requirements";
			this.txtRequirements.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.txtRequirements.Location = new System.Drawing.Point(376, 124);
			this.txtRequirements.Name = "txtRequirements";
			this.txtRequirements.ReadOnly = true;
			this.txtRequirements.Size = new System.Drawing.Size(172, 20);
			this.txtRequirements.TabIndex = 24;
			this.txtRequirements.Text = "";
			// 
			// label3
			// 
			this.label3.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.label3.Location = new System.Drawing.Point(296, 124);
			this.label3.Name = "label3";
			this.label3.Size = new System.Drawing.Size(88, 20);
			this.label3.TabIndex = 20;
			this.label3.Text = "Requirements";
			this.label3.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtComments
			// 
			this.txtComments.AccessibleDescription = "Comments";
			this.txtComments.AccessibleName = "Comments";
			this.txtComments.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtComments.Location = new System.Drawing.Point(110, 124);
			this.txtComments.Multiline = true;
			this.txtComments.Name = "txtComments";
			this.txtComments.ReadOnly = true;
			this.txtComments.Size = new System.Drawing.Size(174, 20);
			this.txtComments.TabIndex = 17;
			this.txtComments.Text = "";
			// 
			// lblComments
			// 
			this.lblComments.Location = new System.Drawing.Point(30, 124);
			this.lblComments.Name = "lblComments";
			this.lblComments.Size = new System.Drawing.Size(68, 20);
			this.lblComments.TabIndex = 10;
			this.lblComments.Text = "Comments";
			this.lblComments.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblSpecimen
			// 
			this.lblSpecimen.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
			this.lblSpecimen.Location = new System.Drawing.Point(30, 148);
			this.lblSpecimen.Name = "lblSpecimen";
			this.lblSpecimen.Size = new System.Drawing.Size(77, 20);
			this.lblSpecimen.TabIndex = 25;
			this.lblSpecimen.Text = "Specimen UID";
			this.lblSpecimen.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtProcedure
			// 
			this.txtProcedure.AccessibleDescription = "Request";
			this.txtProcedure.AccessibleName = "Request";
			this.txtProcedure.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtProcedure.Location = new System.Drawing.Point(110, 100);
			this.txtProcedure.Name = "txtProcedure";
			this.txtProcedure.ReadOnly = true;
			this.txtProcedure.Size = new System.Drawing.Size(174, 20);
			this.txtProcedure.TabIndex = 16;
			this.txtProcedure.Text = "";
			// 
			// lblProcedure
			// 
			this.lblProcedure.Location = new System.Drawing.Point(30, 100);
			this.lblProcedure.Name = "lblProcedure";
			this.lblProcedure.Size = new System.Drawing.Size(59, 20);
			this.lblProcedure.TabIndex = 8;
			this.lblProcedure.Text = "Request";
			this.lblProcedure.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtOrderStatus
			// 
			this.txtOrderStatus.AccessibleDescription = "Order Status";
			this.txtOrderStatus.AccessibleName = "Order Status";
			this.txtOrderStatus.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.txtOrderStatus.Location = new System.Drawing.Point(376, 100);
			this.txtOrderStatus.Name = "txtOrderStatus";
			this.txtOrderStatus.ReadOnly = true;
			this.txtOrderStatus.Size = new System.Drawing.Size(172, 20);
			this.txtOrderStatus.TabIndex = 23;
			this.txtOrderStatus.Text = "";
			// 
			// txtPatientLocation
			// 
			this.txtPatientLocation.AccessibleDescription = "Patient Location";
			this.txtPatientLocation.AccessibleName = "Patient Location";
			this.txtPatientLocation.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.txtPatientLocation.Location = new System.Drawing.Point(376, 48);
			this.txtPatientLocation.Name = "txtPatientLocation";
			this.txtPatientLocation.ReadOnly = true;
			this.txtPatientLocation.Size = new System.Drawing.Size(172, 20);
			this.txtPatientLocation.TabIndex = 21;
			this.txtPatientLocation.Text = "";
			// 
			// txtABORH
			// 
			this.txtABORH.AccessibleDescription = "A B O R h";
			this.txtABORH.AccessibleName = "A B O R h";
			this.txtABORH.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.txtABORH.Location = new System.Drawing.Point(376, 24);
			this.txtABORH.Name = "txtABORH";
			this.txtABORH.ReadOnly = true;
			this.txtABORH.Size = new System.Drawing.Size(172, 20);
			this.txtABORH.TabIndex = 20;
			this.txtABORH.Text = "";
			// 
			// txtPatientName
			// 
			this.txtPatientName.AccessibleDescription = "Patient Name";
			this.txtPatientName.AccessibleName = "Patient Name";
			this.txtPatientName.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtPatientName.Location = new System.Drawing.Point(110, 24);
			this.txtPatientName.Name = "txtPatientName";
			this.txtPatientName.ReadOnly = true;
			this.txtPatientName.Size = new System.Drawing.Size(174, 20);
			this.txtPatientName.TabIndex = 13;
			this.txtPatientName.Text = "";
			// 
			// txtPhysician
			// 
			this.txtPhysician.AccessibleDescription = "Ordered By";
			this.txtPhysician.AccessibleName = "Ordered By";
			this.txtPhysician.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtPhysician.Location = new System.Drawing.Point(110, 76);
			this.txtPhysician.Name = "txtPhysician";
			this.txtPhysician.ReadOnly = true;
			this.txtPhysician.Size = new System.Drawing.Size(174, 20);
			this.txtPhysician.TabIndex = 15;
			this.txtPhysician.Text = "";
			// 
			// txtSSN
			// 
			this.txtSSN.AccessibleDescription = "Patient I D";
			this.txtSSN.AccessibleName = "Patient I D";
			this.txtSSN.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtSSN.Location = new System.Drawing.Point(110, 48);
			this.txtSSN.Name = "txtSSN";
			this.txtSSN.ReadOnly = true;
			this.txtSSN.Size = new System.Drawing.Size(174, 20);
			this.txtSSN.TabIndex = 14;
			this.txtSSN.Text = "";
			// 
			// lblDateWanted
			// 
			this.lblDateWanted.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.lblDateWanted.Location = new System.Drawing.Point(296, 100);
			this.lblDateWanted.Name = "lblDateWanted";
			this.lblDateWanted.Size = new System.Drawing.Size(88, 20);
			this.lblDateWanted.TabIndex = 18;
			this.lblDateWanted.Text = "Order Status";
			this.lblDateWanted.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblPatientLocation
			// 
			this.lblPatientLocation.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.lblPatientLocation.Location = new System.Drawing.Point(296, 48);
			this.lblPatientLocation.Name = "lblPatientLocation";
			this.lblPatientLocation.Size = new System.Drawing.Size(88, 20);
			this.lblPatientLocation.TabIndex = 14;
			this.lblPatientLocation.Text = "Patient Location";
			this.lblPatientLocation.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblPhysician
			// 
			this.lblPhysician.Location = new System.Drawing.Point(30, 76);
			this.lblPhysician.Name = "lblPhysician";
			this.lblPhysician.Size = new System.Drawing.Size(72, 20);
			this.lblPhysician.TabIndex = 6;
			this.lblPhysician.Text = "Ordered By";
			this.lblPhysician.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// label2
			// 
			this.label2.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.label2.Location = new System.Drawing.Point(296, 28);
			this.label2.Name = "label2";
			this.label2.Size = new System.Drawing.Size(88, 20);
			this.label2.TabIndex = 12;
			this.label2.Text = "ABO/Rh";
			this.label2.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblPatientID
			// 
			this.lblPatientID.Location = new System.Drawing.Point(30, 48);
			this.lblPatientID.Name = "lblPatientID";
			this.lblPatientID.Size = new System.Drawing.Size(69, 20);
			this.lblPatientID.TabIndex = 3;
			this.lblPatientID.Text = "Patient ID";
			this.lblPatientID.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblSelectedPatient
			// 
			this.lblSelectedPatient.Location = new System.Drawing.Point(30, 24);
			this.lblSelectedPatient.Name = "lblSelectedPatient";
			this.lblSelectedPatient.Size = new System.Drawing.Size(80, 20);
			this.lblSelectedPatient.TabIndex = 1;
			this.lblSelectedPatient.Text = "Patient Name";
			this.lblSelectedPatient.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// pnlSelectedOrderHeader
			// 
			this.pnlSelectedOrderHeader.BackColor = System.Drawing.SystemColors.ActiveCaption;
			this.pnlSelectedOrderHeader.Controls.Add(this.pnlColor);
			this.pnlSelectedOrderHeader.Controls.Add(this.patientInfoToolbar1);
			this.pnlSelectedOrderHeader.Controls.Add(this.pictureBox2);
			this.pnlSelectedOrderHeader.Controls.Add(this.label6);
			this.pnlSelectedOrderHeader.Dock = System.Windows.Forms.DockStyle.Top;
			this.pnlSelectedOrderHeader.Location = new System.Drawing.Point(0, 0);
			this.pnlSelectedOrderHeader.Name = "pnlSelectedOrderHeader";
			this.pnlSelectedOrderHeader.Size = new System.Drawing.Size(554, 20);
			this.pnlSelectedOrderHeader.TabIndex = 0;
			// 
			// pnlColor
			// 
			this.pnlColor.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.pnlColor.BackColor = System.Drawing.SystemColors.Control;
			this.pnlColor.Controls.Add(this.btnAutoDirUnits);
			this.pnlColor.Controls.Add(this.btnMSBOS);
			this.pnlColor.Controls.Add(this.btnOrderDetails);
			this.pnlColor.Location = new System.Drawing.Point(320, 0);
			this.pnlColor.Name = "pnlColor";
			this.pnlColor.Size = new System.Drawing.Size(80, 20);
			this.pnlColor.TabIndex = 79;
			// 
			// patientInfoToolbar1
			// 
			this.patientInfoToolbar1.AccessibleDescription = "Patient Information";
			this.patientInfoToolbar1.AccessibleName = "Patient Information";
			this.patientInfoToolbar1.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.patientInfoToolbar1.BackColor = System.Drawing.SystemColors.ActiveBorder;
			this.patientInfoToolbar1.EnabledBloodAvailButton = false;
			this.patientInfoToolbar1.EnabledMedicationButton = false;
			this.patientInfoToolbar1.EnabledRecentOrdersButton = false;
			this.patientInfoToolbar1.EnabledRecentTransfusionsIssuesButton = false;
			this.patientInfoToolbar1.EnabledSIAndTRButton = false;
			this.patientInfoToolbar1.EnabledTransfusionReactionHistoryButton = false;
			this.patientInfoToolbar1.Location = new System.Drawing.Point(400, 0);
			this.patientInfoToolbar1.Name = "patientInfoToolbar1";
			this.patientInfoToolbar1.ParentFormInstanceGuid = new System.Guid("00000000-0000-0000-0000-000000000000");
			this.patientInfoToolbar1.Patient = null;
			this.patientInfoToolbar1.Size = new System.Drawing.Size(154, 20);
			this.patientInfoToolbar1.TabIndex = 1;
			// 
			// pictureBox2
			// 
			this.pictureBox2.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox2.Image")));
			this.pictureBox2.Location = new System.Drawing.Point(8, 2);
			this.pictureBox2.Name = "pictureBox2";
			this.pictureBox2.Size = new System.Drawing.Size(16, 16);
			this.pictureBox2.TabIndex = 77;
			this.pictureBox2.TabStop = false;
			// 
			// label6
			// 
			this.label6.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.label6.ForeColor = System.Drawing.SystemColors.ActiveCaptionText;
			this.label6.Location = new System.Drawing.Point(24, 2);
			this.label6.Name = "label6";
			this.label6.Size = new System.Drawing.Size(108, 16);
			this.label6.TabIndex = 0;
			this.label6.Text = "Selected Order";
			this.label6.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// grpSplit
			// 
			this.grpSplit.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpSplit.Location = new System.Drawing.Point(4, 66);
			this.grpSplit.Name = "grpSplit";
			this.grpSplit.Size = new System.Drawing.Size(544, 7);
			this.grpSplit.TabIndex = 5;
			this.grpSplit.TabStop = false;
			// 
			// pnlTreeView
			// 
			this.pnlTreeView.BackColor = System.Drawing.SystemColors.ActiveCaption;
			this.pnlTreeView.Controls.Add(this.pnpPOL);
			this.pnlTreeView.Controls.Add(this.pnlOrderGroupHeader);
			this.pnlTreeView.Dock = System.Windows.Forms.DockStyle.Left;
			this.pnlTreeView.Location = new System.Drawing.Point(0, 0);
			this.pnlTreeView.Name = "pnlTreeView";
			this.pnlTreeView.Size = new System.Drawing.Size(136, 206);
			this.pnlTreeView.TabIndex = 0;
			// 
			// pnpPOL
			// 
			this.pnpPOL.Controls.Add(this.tvPOL);
			this.pnpPOL.Controls.Add(this.btnPrintOrder);
			this.pnpPOL.Dock = System.Windows.Forms.DockStyle.Fill;
			this.pnpPOL.Location = new System.Drawing.Point(0, 20);
			this.pnpPOL.Name = "pnpPOL";
			this.pnpPOL.Size = new System.Drawing.Size(136, 186);
			this.pnpPOL.TabIndex = 1;
			// 
			// tvPOL
			// 
			this.tvPOL.AccessibleDescription = "Order Group";
			this.tvPOL.AccessibleName = "Order Group";
			this.tvPOL.Dock = System.Windows.Forms.DockStyle.Fill;
			this.tvPOL.HideSelection = false;
			this.tvPOL.ImageList = this.imageList1;
			this.tvPOL.Location = new System.Drawing.Point(0, 0);
			this.tvPOL.Name = "tvPOL";
			this.tvPOL.Size = new System.Drawing.Size(136, 163);
			this.tvPOL.TabIndex = 12;
			this.tvPOL.AfterSelect += new System.Windows.Forms.TreeViewEventHandler(this.tvPOL_AfterSelect);
			// 
			// btnPrintOrder
			// 
			this.btnPrintOrder.BackColor = System.Drawing.SystemColors.Control;
			this.btnPrintOrder.Dock = System.Windows.Forms.DockStyle.Bottom;
			this.btnPrintOrder.Enabled = false;
			this.btnPrintOrder.Image = ((System.Drawing.Image)(resources.GetObject("btnPrintOrder.Image")));
			this.btnPrintOrder.ImageAlign = System.Drawing.ContentAlignment.MiddleLeft;
			this.btnPrintOrder.Location = new System.Drawing.Point(0, 163);
			this.btnPrintOrder.Name = "btnPrintOrder";
			this.btnPrintOrder.Size = new System.Drawing.Size(136, 23);
			this.btnPrintOrder.TabIndex = 12;
			this.btnPrintOrder.Text = "Print &Order Group";
			this.btnPrintOrder.Visible = false;
			this.btnPrintOrder.Click += new System.EventHandler(this.btnPrintOrder_Click);
			// 
			// pnlOrderGroupHeader
			// 
			this.pnlOrderGroupHeader.Controls.Add(this.pictureBox8);
			this.pnlOrderGroupHeader.Controls.Add(this.lblOrderGroup);
			this.pnlOrderGroupHeader.Dock = System.Windows.Forms.DockStyle.Top;
			this.pnlOrderGroupHeader.Location = new System.Drawing.Point(0, 0);
			this.pnlOrderGroupHeader.Name = "pnlOrderGroupHeader";
			this.pnlOrderGroupHeader.Size = new System.Drawing.Size(136, 20);
			this.pnlOrderGroupHeader.TabIndex = 0;
			// 
			// pictureBox8
			// 
			this.pictureBox8.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox8.Image")));
			this.pictureBox8.Location = new System.Drawing.Point(8, 2);
			this.pictureBox8.Name = "pictureBox8";
			this.pictureBox8.Size = new System.Drawing.Size(16, 16);
			this.pictureBox8.TabIndex = 2;
			this.pictureBox8.TabStop = false;
			// 
			// lblOrderGroup
			// 
			this.lblOrderGroup.ForeColor = System.Drawing.SystemColors.ActiveCaptionText;
			this.lblOrderGroup.Location = new System.Drawing.Point(24, 2);
			this.lblOrderGroup.Name = "lblOrderGroup";
			this.lblOrderGroup.Size = new System.Drawing.Size(108, 16);
			this.lblOrderGroup.TabIndex = 0;
			this.lblOrderGroup.Text = "Order Group";
			this.lblOrderGroup.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// printDialog1
			// 
			this.printDialog1.AllowPrintToFile = false;
			// 
			// timer1
			// 
			this.timer1.Interval = 1000;
			this.timer1.Tick += new System.EventHandler(this.timer1_Tick);
			// 
			// FrmPendingOrderSearch
			// 
			this.AcceptButton = this.btnAccept;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnCancel;
			this.ClientSize = new System.Drawing.Size(742, 466);
			this.Controls.Add(this.grpSearchPOL);
			this.Controls.Add(this.grpImage2);
			this.Controls.Add(this.btnCancel);
			this.Controls.Add(this.groupBox2);
			this.Controls.Add(this.pnlSelectedOrder);
			this.hlphelpChm.SetHelpKeyword(this, "Orders_UC_16.htm");
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			this.MinimumSize = new System.Drawing.Size(700, 480);
			this.Name = "FrmPendingOrderSearch";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.Text = "VBECS -Accept Orders";
			this.KeyDownSpeakMessage += new gov.va.med.vbecs.GUI.VbecsBaseForm.KeyDownSpeakMessageEventHandler(this.FrmPendingOrderSearch_KeyDownSpeakMessage);
			this.Controls.SetChildIndex(this.pnlSelectedOrder, 0);
			this.Controls.SetChildIndex(this.groupBox2, 0);
			this.Controls.SetChildIndex(this.btnCancel, 0);
			this.Controls.SetChildIndex(this.grpImage2, 0);
			this.Controls.SetChildIndex(this.grpSearchPOL, 0);
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.grpImage2.ResumeLayout(false);
			this.grpSearchPOL.ResumeLayout(false);
			this.groupBox2.ResumeLayout(false);
			this.pnlPOL.ResumeLayout(false);
			this.pnlSelectedOrder.ResumeLayout(false);
			this.pnlSelectedOrderDetails.ResumeLayout(false);
			this.pnlSelectedOrderHeader.ResumeLayout(false);
			this.pnlColor.ResumeLayout(false);
			this.pnlTreeView.ResumeLayout(false);
			this.pnpPOL.ResumeLayout(false);
			this.pnlOrderGroupHeader.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		private void SetOrder(DataRow dtRow)
		{
			if (dtRow.Table.Columns.Contains(Common.VbecsTables.ComponentClass.ComponentClassName))
			{
				_orders.SelectedOrder = new BOL.OrderedComponent(dtRow);
			}
			else
			{
				_orders.SelectedOrder = new BOL.OrderedTest(dtRow);
			}
		}

		/// <summary>
		/// This populates the Selected Order portion of the form.
		/// BR_16.01, BR_16.09, BR_16.21, BR_88.06
		/// </summary>
		private bool PopulateSelectedOrder(DataRow dtRow)
		{
			_loading = true;

			if (this._drPrevious != null)
			{
				//After the Reject Button is clicked, the Rowstate = Detatched, but the DataRow is not null - causes
				//a crash reported by CR2057
				if ( this._drPrevious.RowState != System.Data.DataRowState.Detached)
				{
					string oldCprs = string.Empty;
					string newCprs = string.Empty;

					if (!this._drPrevious.IsNull(Common.VbecsTables.OrderedComponent.CprsOrderNumber))
						oldCprs = this._drPrevious[Common.VbecsTables.OrderedComponent.CprsOrderNumber].ToString();
					if (!dtRow.IsNull(Common.VbecsTables.OrderedComponent.CprsOrderNumber))
						newCprs = dtRow[Common.VbecsTables.OrderedComponent.CprsOrderNumber].ToString();

					if (oldCprs != newCprs)	this.ReleaseLocks(this.CurrentRecordGuid);
				}
			}

			//Call SetLocks before SetOrder, so the Buttons remain inactivated
			if (dtRow.Table.Columns.Contains(Common.VbecsTables.ComponentClass.ComponentClassName))
			{
				if (!this.SetLocks((System.Guid)dtRow[Common.VbecsTables.OrderedComponent.OrderedComponentGuid]))
				{
					this._orders.SelectedOrder = null;
					return(false);
				}
			}
			else
			{
				if (!this.SetLocks((System.Guid)dtRow[Common.VbecsTables.OrderedTest.OrderedTestGuid]))
				{
					this._orders.SelectedOrder  = null;
					return(false);
				}
			}

			SetOrder(dtRow);

			//We've got our lock, so save off the record, so we can compare later... for unlocking
			this._drPrevious = dtRow;

			BOL.OrderedComponent oC = null;
			BOL.OrderedTest oT = null;

			if( !VistALink.EnsureAvailability() )
				return(false);

			// if Ordered Component
			if (_orders.SelectedOrder is BOL.OrderedComponent)
			{
				oC = (BOL.OrderedComponent) _orders.SelectedOrder;

				if (!oC.StillActive)
				{
					GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC016.OrderStatusChanged("accepted or rejected"));
					return(false);
				}
	
				if ( oC.SpecimenRequiredIndicator)
				{
					// specimen already in BB
					if (oC.SpecimenIdentified)  // CR3114
					{
						this.txtSpecimenUID.Text = oC.GetSpecimen().SpecimenUid;  // CR3114
					}
				}
				else
				{
					this.txtSpecimenUID.Text = "NRQ";
				}

				// BR_16.09
				this.txtLabOrderID.Text =	oC.LabOrderNumber;
				this.txtProcedure.Text =	oC.ComponentOrdered.BloodComponentName;
				this.txtOrderStatus.Text =	oC.OrderStatusText;
				//
				if (oC.OrderSpecialInstructions.Trim().Length >0)
				{
					this.txtRequirements.Text = oC.OrderSpecialInstructions;
					// BR_16.21
					Common.Utility.MessageBeep();
				}
				//
				if (oC.Quantity == 1)	this.txtQuantity.Text		= oC.Quantity.ToString() + " Unit";
				else if (oC.Quantity > 1)	this.txtQuantity.Text	= oC.Quantity.ToString() + " Units";

				this.txtComments.Text = oC.OrderedComponentComments;
			}
			// if Ordered Test
			else
			{
				oT = (BOL.OrderedTest) _orders.SelectedOrder;

				if (!oT.StillActive)
				{
					GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC016.OrderStatusChanged("accepted or rejected"));
					return(false);
				}
							
				// BR_16.09
				this.txtLabOrderID.Text =	oT.LabOrderNumber;
				this.txtProcedure.Text =	oT.OrderableTest;
				this.txtOrderStatus.Text =	oT.OrderStatusText;
				this.txtComments.Text =		oT.Comments;

				if (!oT.Specimen.IsNew) this.txtSpecimenUID.Text = oT.Specimen.SpecimenUid;
			}

			// Populate the "Selected Order" part of the form
			//CR 2664 - replaced manually built patient's name with DisplayName property
			this.txtPatientName.Text = _orders.SelectedOrder.Patient.DisplayName;
			this.txtSSN.Text		= _orders.SelectedOrder.Patient.DisplayPatientID;
			this.txtPhysician.Text	= _orders.SelectedOrder.OrderingProviderLastName + ", " + _orders.SelectedOrder.OrderingProviderFirstName;
			// BR_56.01
			if ( _orders.SelectedOrder.Patient.AboRh.Abo.ToString().Trim() == "NA")
			{
				this.txtABORH.Text	= "NR";			
			}
			else
			{
				this.txtABORH.Text	= _orders.SelectedOrder.Patient.AboRh.AboRHText;
			}
			this.ttToolTip.SetToolTip(this.txtABORH, _orders.SelectedOrder.Patient.GetPatientHistoricABORhForTooltip());
			
			string patientRoomBed = dtRow.IsNull(Common.VbecsTables.PatientTreatment.PatientRoomBed) ? string.Empty : dtRow[Common.VbecsTables.PatientTreatment.PatientRoomBed].ToString().Trim(); 
			string patientLocation = dtRow[Common.VbecsTables.PatientTreatment.PatientLocation].ToString().Trim();
 
			if (patientRoomBed == String.Empty)
			{
				this.txtPatientLocation.Text = patientLocation;
			}
			else
			{
				this.txtPatientLocation.Text = patientLocation + ", " + patientRoomBed;
			}
			
			//The info toolbar takes a while to load, only call if we are changing patients
			if (_orders.SelectedOrder.Patient != this.patientInfoToolbar1.Patient)
			{
				this.patientInfoToolbar1.Patient = _orders.SelectedOrder.Patient;
			}

			_loading = false;

			return(true);
		}


		/// <summary>
		/// This populates the PendingOrderList portion of the form.  Using objects would hamper
		/// system preformance significantly, so we'll stick with the data rows here.
		/// </summary>
		private void PopulateListView()
		{
			this.lvSubOrders.Items.Clear();
			bool isOrderedComponent = false;
			Common.OrderStatus orderStatus = Common.OrderStatus.Unknown;

			// Populate ListView
			for (int i=0; i<_orders.DisplayOrders.Count; i++)
			{
				DataRow dtRow = (DataRow) _orders.DisplayOrders[i];	

				if (dtRow.Table.Columns.Contains(Common.VbecsTables.ComponentClass.ComponentClassName))
				{
					isOrderedComponent = true;
					orderStatus = Common.Utility.GetOrderStatusCodeFromString(dtRow[Common.VbecsTables.OrderedComponent.OrderStatusCode].ToString());
				}
				else
				{
					isOrderedComponent = false;
					orderStatus = Common.Utility.GetOrderStatusCodeFromString(dtRow[Common.VbecsTables.OrderedTest.OrderStatusCode].ToString());
				}
				
				// only display Pending orders
				if (orderStatus != Common.OrderStatus.Pending) continue;

				ListViewItem lvOrderItem = new ListViewItem();
				lvOrderItem.Tag = dtRow;

				if (isOrderedComponent) 
				{
					lvOrderItem.ImageIndex = 17;
					//CR 2664 - added check to see if middle name is null to avoid system crash
					if (dtRow.IsNull(Common.VbecsTables.Patient.PatientMiddleName) == false)
						lvOrderItem.SubItems.Add(BOL.Patient.BuildDisplayName(dtRow[Common.VbecsTables.Patient.PatientFirstName].ToString(),dtRow[Common.VbecsTables.Patient.PatientMiddleName].ToString(),dtRow[Common.VbecsTables.Patient.PatientLastName].ToString()) );
					else
						lvOrderItem.SubItems.Add(BOL.Patient.BuildDisplayName(dtRow[Common.VbecsTables.Patient.PatientFirstName].ToString(), "",dtRow[Common.VbecsTables.Patient.PatientLastName].ToString()) );
					lvOrderItem.SubItems.Add(dtRow[Common.VbecsTables.Patient.DisplayVistaPatientId].ToString());
					lvOrderItem.SubItems.Add(dtRow[Common.VbecsTables.PatientSpecimen.SpecimenUid].ToString());
					lvOrderItem.SubItems.Add(dtRow[Common.VbecsTables.OrderedComponent.LabOrderNumber].ToString());
					lvOrderItem.SubItems.Add(dtRow[Common.VbecsTables.OrderUrgency.OrderUrgencyText].ToString());
					// BR_16.02			
					if ((bool) dtRow[Common.VbecsTables.OrderedComponent.SpecimenRequiredIndicator])
					{
						lvOrderItem.SubItems.Add("Required");
					}
					else
					{
						lvOrderItem.SubItems.Add("Not required");
					}
					lvOrderItem.SubItems.Add(dtRow[Common.VbecsTables.ComponentClass.ComponentClassName].ToString()+" x "+dtRow[Common.VbecsTables.OrderedComponent.RequiredUnitQuantity].ToString());
				}
				else
				{
					lvOrderItem.ImageIndex = 18;
					//CR 2664 - added check to see if middle name is null to avoid system crash and replaced manually built patient name with call to BuildDisplayName method
					if (dtRow.IsNull(Common.VbecsTables.Patient.PatientMiddleName) == false)
						lvOrderItem.SubItems.Add(BOL.Patient.BuildDisplayName(dtRow[Common.VbecsTables.Patient.PatientFirstName].ToString(),dtRow[Common.VbecsTables.Patient.PatientMiddleName].ToString(),dtRow[Common.VbecsTables.Patient.PatientLastName].ToString()) );
					else
						lvOrderItem.SubItems.Add(BOL.Patient.BuildDisplayName(dtRow[Common.VbecsTables.Patient.PatientFirstName].ToString(), "",dtRow[Common.VbecsTables.Patient.PatientLastName].ToString()) );
					lvOrderItem.SubItems.Add(dtRow[Common.VbecsTables.Patient.DisplayVistaPatientId].ToString());
					lvOrderItem.SubItems.Add(dtRow[Common.VbecsTables.PatientSpecimen.SpecimenUid].ToString());
					lvOrderItem.SubItems.Add(dtRow[Common.VbecsTables.OrderedTest.LabOrderNumber].ToString());
					lvOrderItem.SubItems.Add(dtRow[Common.VbecsTables.OrderUrgency.OrderUrgencyText].ToString());
					lvOrderItem.SubItems.Add("Required");
					lvOrderItem.SubItems.Add(dtRow[Common.VbecsTables.OrderableTest.OrderableTestName].ToString());
				}
		
				lvOrderItem.SubItems.Add(dtRow[Common.VbecsTables.PatientOrder.OrderingProviderLastName].ToString() + ", " + dtRow[Common.VbecsTables.PatientOrder.OrderingProviderFirstName].ToString());
				//				
				string patientRoomBed = dtRow.IsNull(Common.VbecsTables.PatientTreatment.PatientRoomBed) ? string.Empty : dtRow[Common.VbecsTables.PatientTreatment.PatientRoomBed].ToString().Trim(); 
				string patientLocation = dtRow[Common.VbecsTables.PatientTreatment.PatientLocation].ToString().Trim();
 
				if (patientRoomBed == String.Empty)
				{
					lvOrderItem.SubItems.Add(patientLocation);
				}
				else
				{
					lvOrderItem.SubItems.Add(patientLocation + ", " + patientRoomBed);
				}

				if ( ((DateTime) dtRow[Common.VbecsTables.PatientOrder.OrderReceivedDatetime]) == DateTime.MinValue)
				{
					lvOrderItem.SubItems.Add("Unknown");
				}
				else
				{
					lvOrderItem.SubItems.Add( Common.VBECSDateTime.FormatDateTimeString( (DateTime) dtRow[Common.VbecsTables.PatientOrder.OrderReceivedDatetime] ));
				}

				if (isOrderedComponent)
				{
					if ( dtRow[Common.VbecsTables.OrderedComponent.RequiredDatetime] == System.DBNull.Value || ((DateTime) dtRow[Common.VbecsTables.OrderedComponent.RequiredDatetime]) == DateTime.MinValue) lvOrderItem.SubItems.Add("Not specified");
					else lvOrderItem.SubItems.Add(Common.VBECSDateTime.FormatDateTimeString( (DateTime) dtRow[Common.VbecsTables.OrderedComponent.RequiredDatetime]));
				}
				else
				{
					if ( dtRow[Common.VbecsTables.OrderedTest.RequiredResultsDate] == System.DBNull.Value || ((DateTime) dtRow[Common.VbecsTables.OrderedTest.RequiredResultsDate]) == DateTime.MinValue) lvOrderItem.SubItems.Add("Not specified");
					else lvOrderItem.SubItems.Add(Common.VBECSDateTime.FormatDateTimeString( (DateTime) dtRow[Common.VbecsTables.OrderedTest.RequiredResultsDate]));
				}
				lvOrderItem.SubItems.Add(dtRow[Common.VbecsTables.PatientOrder.OrderGroupNumber].ToString());
				this.lvSubOrders.Items.Add(lvOrderItem);
			}
			controls.VbecsFunction.SetColumnWidths(this.lvSubOrders);
		}


		/// <summary>
		/// This method populates the Order Group (TreeView) portion of the form.
		/// </summary>
		private void PopulateTreeView()
		{
			ArrayList treeNodes = new ArrayList();
			int nCount = 0;
			tvPOL.Nodes.Clear();
			treeNodes.Clear();

			if (_orders.SelectedOrder != null)
			{
				nCount = _orders.AllTestOrders.Rows.Count;
				for(int i=0; i<nCount; i++)
				{
					DataRow dtRow = (DataRow) _orders.AllTestOrders.Rows[i];
					string statusMessage = String.Empty;
					TreeNode tn = null;
					
					// skip orders not in this group
					if (!_orders.SelectedOrder.OrderGroupNumber.Trim().Equals( dtRow[Common.VbecsTables.PatientOrder.OrderGroupNumber].ToString().Trim() )) continue;

					Common.OrderStatus orderStatusCode = Common.Utility.GetOrderStatusCodeFromString(dtRow[Common.VbecsTables.OrderStatus.OrderStatusCode].ToString());
					if (orderStatusCode == Common.OrderStatus.Accepted) 
					{
						statusMessage = " - Already Accepted";
					}
					else if (orderStatusCode == Common.OrderStatus.Cancelled)
					{
						statusMessage = " - Cancelled";
					}

					tn = new TreeNode(dtRow[Common.VbecsTables.OrderableTest.OrderableTestName].ToString() + statusMessage, 18, 18);
				
					tn.Tag = dtRow;
					treeNodes.Add(tn);
				}
				nCount = _orders.AllComponentOrders.Rows.Count;
				for(int i=0; i<nCount; i++)
				{
					DataRow dtRow = (DataRow) _orders.AllComponentOrders.Rows[i];
					string statusMessage = String.Empty;
					TreeNode tn = null;
					
					// skip orders not in this group
					if (!_orders.SelectedOrder.OrderGroupNumber.Trim().Equals( dtRow[Common.VbecsTables.PatientOrder.OrderGroupNumber].ToString().Trim() )) continue;

					Common.OrderStatus orderStatusCode = Common.Utility.GetOrderStatusCodeFromString(dtRow[Common.VbecsTables.OrderStatus.OrderStatusCode].ToString());
					if (orderStatusCode == Common.OrderStatus.Accepted)
					{
						statusMessage = " - Already Accepted";
					}
					else if (orderStatusCode == Common.OrderStatus.Cancelled)
					{
						statusMessage = " - Cancelled";
					}

					tn = new TreeNode(dtRow[Common.VbecsTables.ComponentClass.ComponentClassName].ToString() + statusMessage, 17, 17);
				
					tn.Tag = dtRow;
					treeNodes.Add(tn);
				}

				// Only populate if there is data
				if (treeNodes.Count > 0)
				{
					TreeNode [] nodeArray = new TreeNode[treeNodes.Count];

					for (int i=0; i<treeNodes.Count; i++)
					{
						nodeArray[i] = (TreeNode) treeNodes[i];
					}

					//CR 2664 - replaced manually built patient's name with DisplayName property
					TreeNode tN = new TreeNode(_orders.SelectedOrder.Patient.DisplayName, 1, 1, (TreeNode[]) nodeArray);
					this.tvPOL.Nodes.Add(tN);
					this.tvPOL.ExpandAll();
				}
			}
		}


		/// <summary>
		/// Initializes controls on the form.
		/// </summary>
		private void SetComponentProperties()
		{
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			this.btnAccept.Text = "&Accept";
			this.ttToolTip.SetToolTip(this.btnAccept, Common.StrRes.Tooltips.UC016.SelectOrder().ResString);
			this.btnSearch.Text = "&Search";
			this.ttToolTip.SetToolTip(this.btnSearch, Common.StrRes.Tooltips.UC016.SearchCriteria().ResString);

			//set custom date and time format
			this.dtpDateEnd.CustomFormat = Common.VBECSDateTime.DateFormat;
			this.dtpDateStart.CustomFormat = Common.VBECSDateTime.DateFormat;

			//set current date value based on the division time zone
			System.DateTime _currentDate = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
			this.dtpDateStart.Value = _currentDate;
			this.dtpDateEnd.Value = _currentDate;
		}


		// Clears the Selected Order portion of the form
		private void ClearForm()
		{
			this.txtPatientName.Text	= string.Empty;
			this.txtSSN.Text			= string.Empty;
			this.txtPhysician.Text		= string.Empty;
			this.txtProcedure.Text		= string.Empty;
			this.txtComments.Text		= string.Empty;
			//
			this.txtABORH.Text			= string.Empty;
			this.txtPatientLocation.Text = string.Empty;
			this.txtLabOrderID.Text		= string.Empty;
			this.txtOrderStatus.Text	= string.Empty;
			this.txtRequirements.Text	= string.Empty;
			this.txtQuantity.Text		= string.Empty;
			//
			this.txtSpecimenUID.Text	= string.Empty;
			this.cbEmergencyOrder.Checked = false;
		}


		/// <summary>
		/// Enables/ disables various buttons on the form.
		/// </summary>  
		private void SetOptionButtons()
		{
			if (_orders.SelectedOrder == null)
			{
				this.btnReject.Enabled			= false;
				this.btnOrderDetails.Enabled	= false;
				this.btnMSBOS.Enabled			= false;
				this.btnAutoDirUnits.Enabled	= false;
				this.btnPrintOrder.Enabled		= false;
				this.patientInfoToolbar1.Patient = null;
			}
			else
			{
				this.btnOrderDetails.Enabled	= true;

				// BR_16.11 - Enable only when the PreOpIndicator is set to true
				this.btnMSBOS.Enabled = (_orders.SelectedOrder is BOL.OrderedComponent &&
					( (BOL.OrderedComponent) _orders.SelectedOrder).PreOpIndicator == true);
		
				this.btnPrintOrder.Enabled = true;
			}
		}

		#endregion


		#region events

		private void btnSearch_Click(object sender, System.EventArgs e)
		{
			_orders.SelectedOrder = null;
			this.tvPOL.Nodes.Clear();

			// clear out ListView and Orders
			this.lvSubOrders.Items.Clear();
			this.ClearForm();
											
			_orders.FilterOrdersForDisplay(this.txtSpecimen.Text, this.cbDateWanted.Checked, this.dtpDateStart.Value, this.dtpDateEnd.Value, this.txtPatient.Text, this.txtOrder.Text);

			PopulateListView();	
			if (this.lvSubOrders.Items.Count == 0)
			{
				MessageBox.Show(Common.StrRes.InfoMsg.UC020.NoMatchingEntries().ResString);
			}

			//Clear all locks since they wiped the grid
			this.UnlockAllRecords();
		}

		/// <summary>
		/// lvSubOrders_SelectedIndexChanged Event Handler
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void lvSubOrders_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			this.ClearForm();
		
			if (lvSubOrders.SelectedIndices.Count > 0)
			{
				using (new WaitCursor())
				{
					//ListViewItem lVI = ((System.Windows.Forms.ListView) sender).SelectedItems[0];
					ListViewItem lVI = ((System.Windows.Forms.ListView) lvSubOrders).SelectedItems[0];

					DataRow dtRow = (DataRow) lVI.Tag;
					//SetOrder(dtRow);
					if (this.PopulateSelectedOrder(dtRow))
						this.PopulateTreeView();
				}
			}
		}


		private void btnClear_Click(object sender, System.EventArgs e)
		{
			this.txtSpecimen.Text = string.Empty;
			this.txtPatient.Text = string.Empty;
			this.cbDateWanted.Checked = false;
			this.txtOrder.Text = string.Empty;
		}


		private void SearchStateChanged(object sender, System.EventArgs e)
		{
			if (this.txtSpecimen.Text.Trim().Length > 0 ||
				this.cbDateWanted.Checked == true ||
				this.txtPatient.Text.Trim().Length > 0 ||
				this.txtOrder.Text.Trim().Length > 0)
			{
				this.btnSearch.EnabledButton = true;
				this.ttToolTip.SetToolTip(btnSearch, string.Empty);
			}
			else
			{
				this.btnSearch.EnabledButton = true;
				this.ttToolTip.SetToolTip(this.btnSearch, "Please enter search criteria");
			}

			if(this.cbDateWanted.Checked == true)
			{
				this.dtpDateStart.Enabled = true;
				this.dtpDateEnd.Enabled = true;
			}
			else
			{
				this.dtpDateStart.Enabled = false;
				this.dtpDateEnd.Enabled = false;
			}
		}


		// BR_88.09
		private void lvSubOrders_ColumnClick(object sender, System.Windows.Forms.ColumnClickEventArgs e)
		{
			controls.ColumnClickSorter.ColumnClickHandler(sender, e, this.lvSubOrders.CheckBoxes, controls.ColumnClickSorter.ColumnSortType.String);
		}

		private void btnOrderDetails_Click(object sender, System.EventArgs e)
		{
			if (lvSubOrders.SelectedIndices.Count > 0 || tvPOL.SelectedNode != null)
			{
				DlgOrderDetails dlgOD = new DlgOrderDetails(_orders.SelectedOrder);
                dlgOD.ShowDialogFromLockedParent(this, false);
			}
		}

		private void btnMSBOS_Click(object sender, System.EventArgs e)
		{
			DlgMsbos DlgMsbos = new DlgMsbos( ((BOL.OrderedComponent) _orders.SelectedOrder).SurgeryName, ( (BOL.OrderedComponent) _orders.SelectedOrder).InappropriateRequestIndicator  );
			DlgMsbos.ShowDialogFromLockedParent(this, false);
			if (DlgMsbos.AcceptButton.DialogResult == DialogResult.OK)
			{
				((BOL.OrderedComponent) _orders.SelectedOrder).InappropriateRequestIndicator = DlgMsbos.CheckState;;
			}
		}

		private void btnAutoDirUnits_Click(object sender, System.EventArgs e)
		{
			DlgSelectDirectedUnits dlg = new DlgSelectDirectedUnits(_orders.SelectedOrder.Patient.PatientGuid);
			dlg.ShowDialogFromLockedParent(this, true);
		}

		private void btnSIandTR_Click(object sender, System.EventArgs e)
		{
			if (lvSubOrders.SelectedIndices.Count > 0)
			{
				ListViewItem lVI = this.lvSubOrders.SelectedItems[0];
				BOL.PatientOrder patientOrder = (BOL.PatientOrder) lVI.Tag;

				DlgDisplayTransReqsAndSpecIns dlg = new DlgDisplayTransReqsAndSpecIns(patientOrder.Patient);
				if (dlg.DialogResult != DialogResult.Abort)
				{
					dlg.ShowDialogFromLockedParent(this, false);
				}
				else
					dlg.Dispose();
			}
		}

		private void btnAccept_Click(object sender, System.EventArgs e)
		{
			bool save = true;
			string cannedCommentText = null;
			string orderGroupNumber = _orders.SelectedOrder.OrderGroupNumber;

			using ( new WaitCursor() )
			{
				#region Ordered Component save

				if (_orders.SelectedOrder is BOL.OrderedComponent)
				{
					BOL.OrderedComponent oC = (BOL.OrderedComponent) _orders.SelectedOrder;

					if (!oC.StillActive)
					{
						GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC016.OrderStatusChanged("accepted"));
						return;
					}

					ArrayList failedLabTests = new ArrayList();
					if ( oC.PreOpIndicator == false)
					{
						DataTable dt = BOL.TestResult.GetTestResults(_orders.SelectedOrder.PatientOrderGuid);
						failedLabTests = BOL.LabTest.DoTestsExceedThreshold( oC.ComponentOrdered.BloodComponentClassId, dt);
									
						// BR_16.04
						if (failedLabTests.Count > 0)
						{
							int count = 0;
							StringBuilder message = new StringBuilder();
							foreach (string failedLabTest in failedLabTests)
							{
								message.Append(failedLabTest);
								if (failedLabTests.Count != count+1) message.Append(", ");
								count++;
							}
							if (GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.UC016.FailedTests(
								message.ToString(), oC.ComponentOrdered.BloodComponentName)) == DialogResult.Yes)
							{
								((BOL.OrderedComponent) _orders.SelectedOrder).InappropriateRequestIndicator = true;
							}
							else
							{
								DlgOverrideComment dlg = new DlgOverrideComment("Threshold Exceeded", "The test values exceed site parameters for this component class ordered.\nPlease enter a comment to continue.\nClicking Cancel will result in the order not being accepted", "OP");
                                dlg.ShowDialogFromLockedParent(this, false);
                                if (dlg.DialogResult != DialogResult.OK)
								{
                                    return; //CR3308 - was returning false which doesn't stop the locking timers
								}
								else
								{
									((BOL.OrderedComponent) _orders.SelectedOrder).NoInappropriateReportText = dlg.Comment;
								}
							}
						}
					}
			
					if (save == true)
					{
						DialogResult saveResult = GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.Common.OKToSave(String.Empty));
						if (saveResult == DialogResult.Yes)
						{
							bool saveSpecimen = false;
							BOL.ExceptionReport exRep = null;
							
							if (this.txtSpecimenUID.Text.Trim().Length > 9) saveSpecimen = true; // CR2877: eliminate the check for 10
							if (oC.ComponentOrdered.IsSpecimenRequired && saveSpecimen == false)
							{
								Common.ExceptionType exceptionType = Common.ExceptionType.Emergency_issue_request;
								exRep = new BOL.ExceptionReport(exceptionType, "Emergency order accepted: no specimen", Common.LogonUser.LogonUserName);
								
								exRep.GenerateExceptionEmergencyIssueOrder(oC);
							}

							oC.OrderStatusCode = Common.OrderStatus.Accepted;
							try
							{
								oC.UpdateStatus
									(
									Common.Utility.GetOrderStatusCodeFromEnum(Common.OrderStatus.Accepted), 
									Common.Utility.GetTaskStatusCodeFromEnum(Common.TaskStatus.NotStarted), 
									Common.LogonUser.LogonUserName, 
									Guid.Empty,  
									cannedCommentText,
									saveSpecimen,
									exRep,
									Common.UpdateFunction.UC016FrmPendingOrderSearch
									);
								// This order has been accepted, so we don't want to see it if another search is done.
								DataRow [] dtRows =  _orders.AllComponentOrders.Select(Common.VbecsTables.OrderedComponent.OrderedComponentGuid +  
									" = '" + oC.OrderedComponentGuid + "'"); 				
								dtRows[0][Common.VbecsTables.OrderedComponent.OrderStatusCode] = Common.Utility.GetOrderStatusCodeFromEnum(Common.OrderStatus.Accepted);
								_orders.Remove(dtRows[0][Common.VbecsTables.OrderedComponent.CprsOrderNumber].ToString(), false);
								this.cbEmergencyOrder.Checked = false;

								this.ReleaseLocks(this.CurrentRecordGuid);
								//CR 1441
								System.Data.DataTable dt  = BOL.WorkloadEvent.GetWorkloadProcessGuidByProcessID((int) Common.WorkloadProcessID.AcceptOrder);
								if(dt!= null)
								{
									if(dt.Rows.Count == 0)
									{
										GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC015.BR1502_NoWorkloadDefined());
									}
								}
							}
							catch(RowVersionException)
							{
								this.btnAccept.RowVersionException = true;		//CR2077
								GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.DataWasNotSavedBecauseOfRowversionViolation());
							}
						}
					}
				}

				#endregion


				#region Ordered Test save

				if (_orders.SelectedOrder is BOL.OrderedTest)
				{
					BOL.OrderedTest oT = (BOL.OrderedTest) _orders.SelectedOrder;

					if (!oT.StillActive)
					{
						GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC016.OrderStatusChanged("accepted"));
						return;
					}

					DialogResult saveResult = GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.Common.OKToSave(""));
					if (saveResult == DialogResult.Yes)
					{
						// Create and save non-maintainable specimens
						try
						{
							DataTable dtSpecimen = null;

							// Requires a non-maintainable specimen
							if (oT.OrderableTestId != (int) Common.OrderableTest.TAS)
							{
								// specimen
								BOL.Specimen specimen = ( (BOL.OrderedTest) _orders.SelectedOrder).Specimen; // CR 2817
								specimen.Patient = _orders.SelectedOrder.Patient;
								specimen.MaintainableSpecimenIndicator = false;
								oT.Specimen = specimen;

								if (specimen.IsNew)
								{
									DataSet ds = specimen.GetSpecimenSaveDataset();
									dtSpecimen = ds.Tables[BOL.Specimen.SPECIMENTABLE];
								}
							}
							oT.OrderStatusCode = Common.OrderStatus.Accepted;
						
							oT.UpdateStatus(
								Common.Utility.GetOrderStatusCodeFromEnum(Common.OrderStatus.Accepted), 
								Common.Utility.GetTaskStatusCodeFromEnum(Common.TaskStatus.NotStarted), 
								Common.LogonUser.LogonUserName, 
								Guid.Empty, 
								cannedCommentText, 
								oT.CPRSOrderNumber,
								dtSpecimen,
								Common.UpdateFunction.UC016FrmPendingOrderSearch
								);
							// The user may conduct another search in the same session.  Since the DataTables are recycled, the
							// status of the Order must be updated.
							DataRow [] dtRows =  _orders.AllTestOrders.Select(Common.VbecsTables.OrderedTest.OrderedTestGuid + 
								" = '" + oT.OrderedTestGuid + "'"); 		
							dtRows[0][Common.VbecsTables.OrderedTest.OrderStatusCode] = Common.Utility.GetOrderStatusCodeFromEnum(Common.OrderStatus.Accepted);
							_orders.Remove(dtRows[0][Common.VbecsTables.OrderedComponent.CprsOrderNumber].ToString(), false);
							
							this.ReleaseLocks(this.CurrentRecordGuid);
							//CR 1441
							System.Data.DataTable dt  = BOL.WorkloadEvent.GetWorkloadProcessGuidByProcessID((int) Common.WorkloadProcessID.AcceptOrder);
							if(dt!= null)
							{
								if(dt.Rows.Count == 0)
								{
									GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC015.BR1502_NoWorkloadDefined());
								}
							}
						}
						catch(RowVersionException)
						{
							this.btnAccept.RowVersionException = true;		//CR2077
							GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.DataWasNotSavedBecauseOfRowversionViolation());
						}
					}
				}

				#endregion

				_orders.SelectedOrder = null;

				this.PopulateListView();
				this.PopulateTreeView();
				this.ClearForm();
				this.IsDirty = false;
				this.SelectNextOrderFromGroup(orderGroupNumber);
			}
		}


		private void btnReject_Click(object sender, System.EventArgs e)
		{
			string orderGroupNumber = _orders.SelectedOrder.OrderGroupNumber;

			if ((_orders.SelectedOrder is BOL.OrderedComponent && !((BOL.OrderedComponent)_orders.SelectedOrder).StillActive)
				|| (_orders.SelectedOrder is BOL.OrderedTest && !((BOL.OrderedTest)_orders.SelectedOrder).StillActive))
			{
				GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC016.OrderStatusChanged("rejected"));
				return;
			}

			DlgCancelOrder dlgCO = new DlgCancelOrder();
			dlgCO.ShowDialogFromLockedParent(this, false);
			if (dlgCO.DialogResult == DialogResult.OK)

			{
				Guid cannedCommentGuid = dlgCO.CannedCommentGuid;
				string cannedCommentText = dlgCO.CannedCommentText;

				try
				{
					// Save the component or test
					if (_orders.SelectedOrder is BOL.OrderedComponent)
					{
						( (BOL.OrderedComponent) _orders.SelectedOrder).UpdateStatus(
							Common.Utility.GetOrderStatusCodeFromEnum(Common.OrderStatus.Cancelled),
							Common.Utility.GetTaskStatusCodeFromEnum(Common.TaskStatus.Unknown), 
							Common.LogonUser.LogonUserName, 
							cannedCommentGuid, 
							cannedCommentText, 
							false,
							null,
							Common.UpdateFunction.UC016FrmPendingOrderSearch
							);

						DataRow [] dtRows =  _orders.AllComponentOrders.Select(Common.VbecsTables.OrderedComponent.OrderedComponentGuid +  " = '" + ( (BOL.OrderedComponent) _orders.SelectedOrder).OrderedComponentGuid + "'"); 
						_orders.Remove(dtRows[0][Common.VbecsTables.OrderedComponent.CprsOrderNumber].ToString(), true);						
						_orders.AllComponentOrders.Rows.Remove(dtRows[0]);
						
					}
					else
					{
						( (BOL.OrderedTest) _orders.SelectedOrder).UpdateStatus(
							Common.Utility.GetOrderStatusCodeFromEnum(Common.OrderStatus.Cancelled), 
							Common.Utility.GetTaskStatusCodeFromEnum(Common.TaskStatus.Unknown), 
							Common.LogonUser.LogonUserName, 
							cannedCommentGuid, 
							cannedCommentText, 
							( (BOL.OrderedTest) _orders.SelectedOrder).CPRSOrderNumber,
							null,
							Common.UpdateFunction.UC016FrmPendingOrderSearch
							);
						DataRow [] dtRows = _orders.AllTestOrders.Select(Common.VbecsTables.OrderedTest.OrderedTestGuid + " = '" + ( (BOL.OrderedTest) _orders.SelectedOrder).OrderedTestGuid + "'"); 
						_orders.Remove(dtRows[0][Common.VbecsTables.OrderedTest.CprsOrderNumber].ToString(), true);
						_orders.AllTestOrders.Rows.Remove(dtRows[0]);
					}
					//CR 1441
					System.Data.DataTable dt  = BOL.WorkloadEvent.GetWorkloadProcessGuidByProcessID((int) Common.WorkloadProcessID.CancelOrder);
					if(dt!= null)
					{
						if(dt.Rows.Count == 0)
						{
							GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC015.BR1502_NoWorkloadDefined());
						}
					}
				}
				catch(RowVersionException)
				{
//					this.btnReject.RowVersionException = true;		//CR2077
					GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.DataWasNotSavedBecauseOfRowversionViolation());
				}
			
				
				this.ReleaseLocks(this.CurrentRecordGuid);

				_orders.SelectedOrder = null;
				//reload screen to remove order that has been Accepted/Rejected
				this.ClearForm();
				this.PopulateListView(); 
				this.PopulateTreeView();
				this.tvPOL.Nodes.Clear();
				//this.SetButtons();

				this.SelectNextOrderFromGroup(orderGroupNumber);
			}
		}

		private void btnPrint_Click(object sender, System.EventArgs e)
		{
			if (lvSubOrders.Items.Count == 0)
			{
				GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC016.NoOrders());
			}
			else
			{
				System.Drawing.Printing.PrinterSettings settings = new System.Drawing.Printing.PrinterSettings();
				printDialog1.PrinterSettings = settings;
				if (printDialog1.ShowDialog(this) == DialogResult.OK)       //TODO: Locking Test - ShowDialogFromLockedParent()
				{
					using (new WaitCursor())
					{
						_orders.PrintReport(settings);
					}
				}
			}
		}

		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}

		/// <summary>
		/// Handles the user clicking on a node in the TreeView
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void tvPOL_AfterSelect(object sender, System.Windows.Forms.TreeViewEventArgs e)
		{
			TreeNode tn = ((TreeView) sender).SelectedNode;

			// If this isn't a child node, skip it
			if (tn != null)
			{
				using (new WaitCursor())
				{
					this.ClearForm();
					this.lvSubOrders.SelectedItems.Clear();
					if (tn.GetNodeCount(false) == 0)
					{
						DataRow dtRow = (DataRow) tn.Tag;
						//this.SetOrder(dtRow);
						this.PopulateSelectedOrder(dtRow);
					}
					else
					{
						_orders.SelectedOrder = null;
					}
				}
			}
		}
		
		private void txtSpecimen_Leave(object sender, System.EventArgs e)
		{
			if (this.txtSpecimen.Text.Length > 0)
			{
				if (this.txtSpecimen.Text.Substring(0,1) == "~")
				{
					this.txtSpecimen.Text = this.txtSpecimen.Text.Substring(1);
				}
			}
		}

		private void btnPrintOrder_Click(object sender, System.EventArgs e)
		{
			BOL.PatientOrder.PrintPatientOrderAlert(_orders.SelectedOrder.PatientOrderGuid, ThisUser.UserName ,Common.LogonUser.LogonUserDivisionCode);
		}

		private void cbEmergencyOrder_CheckedChanged(object sender, System.EventArgs e)
		{
			if (cbEmergencyOrder.Checked)
			{
				((BOL.OrderedComponent) _orders.SelectedOrder).EmergencyOrderIndicator = true;
				this.txtSpecimenUID.Text = string.Empty;
				this.txtSpecimenUID.ReadOnly = true; //508 compliance
				this.btnAccept.EnabledButton = true;
				this.IsDirty = true;  // CR2909
				this.errError.SetVbecsError(this.txtSpecimenUID, string.Empty); // **** 508 Compliance ***
			}
			else
			{
				if (_orders.SelectedOrder != null) ((BOL.OrderedComponent) _orders.SelectedOrder).EmergencyOrderIndicator = false;
				this.txtSpecimenUID.ReadOnly = false; //508 compliance
				this.lvSubOrders_SelectedIndexChanged(null, System.EventArgs.Empty);
				
				// disable the button and set error
				this.ttToolTip.SetToolTip(this.btnAccept, Common.StrRes.Tooltips.UC016.SpecimenUIDRequired().ResString);
				this.btnAccept.EnabledButton = false;
				this.IsDirty = false;  // CR2909
			}
		}

		#endregion

		/// <summary>
		/// Gets the right record guid of our current Order
		/// </summary>
		private System.Guid CurrentRecordGuid
		{
			get
			{
				//Just in case we the object was cleared, return Empty, so processing continues
				if (_orders.SelectedOrder == null) return(System.Guid.Empty);

				if (_orders.SelectedOrder is BOL.OrderedComponent)
				{
					return(((BOL.OrderedComponent)_orders.SelectedOrder).OrderedComponentGuid);
				}
				else
				{
					return((BOL.OrderedTest)_orders.SelectedOrder).OrderedTestGuid;
				}
			}
		}

		#region Properties


		private void txtSpecimenUID_TextChanged(object sender, System.EventArgs e)
		{
            // CR3399: Disable the button here to prevent lag
            if (_status != Common.AcceptOrderStatus.ReadyForAcceptance) this.btnAccept.EnabledButton = false;

			// CR2909 start
			if (!_loading && txtSpecimenUID.Text.Length>0) this.IsDirty = true;
			else this.IsDirty = false;
			// CR2909 end

			ProcessSpecimen();
		}

		private void ProcessSpecimen()
		{
			timer1.Enabled = false;
			//
			if (this.txtSpecimenUID.Text.Trim().Length >0)
			{
				timer1.Enabled = true;
			}
			else if (this.txtSpecimenUID.Text.Length == 0 && this.txtSpecimenUID.Text.Trim() != "NRQ")
			{
				this.ttToolTip.SetToolTip(this.btnAccept, Common.StrRes.Tooltips.UC016.SpecimenUIDRequired().ResString);
				this.btnAccept.EnabledButton = false;
			}
		}

		/// <summary>
		/// UpdateSpecimen
		/// </summary>
		/// <returns></returns>
		private bool UpdateSpecimen()
		{
			DialogResult result = DialogResult.None;
			FrmMaintainSpecimen frm = null;

			if (_orders.SelectedOrder is BOL.OrderedComponent) 
			{
				frm = new FrmMaintainSpecimen( ((BOL.OrderedComponent) _orders.SelectedOrder).GetSpecimen(), _orders.SelectedOrder);
			}
			else
			{
				((BOL.OrderedTest) _orders.SelectedOrder).Specimen.SpecimenUid = this.txtSpecimenUID.Text.Trim();
				frm = new FrmMaintainSpecimen( ((BOL.OrderedTest) _orders.SelectedOrder).Specimen, _orders.SelectedOrder);
			}
			frm.ShowDialogFromLockedParent(this,false);

			if (frm.DialogResult == DialogResult.OK)
			{
				if (_orders.SelectedOrder is BOL.OrderedComponent) ( (BOL.OrderedComponent) _orders.SelectedOrder).AssociateWithSpecimen(frm.Specimen);  // CR3114 todo3114
				else ( (BOL.OrderedTest) _orders.SelectedOrder).Specimen = frm.Specimen;

				// Trigger check
				this.btnAccept.EnabledButton = true;
			}
			return (result == DialogResult.OK);
		}

		private void SelectNextOrderFromGroup(string orderGroupNumber)
		{
			foreach(ListViewItem lvi in this.lvSubOrders.Items)
			{
				DataRow dr = (DataRow)lvi.Tag;
				if (dr[Common.VbecsTables.PatientOrder.OrderGroupNumber].ToString() == orderGroupNumber)
				{
					lvi.EnsureVisible();
					lvi.Selected = true;
					break;
				}
				_orders.SelectedOrder = null;
			}	
		}

		#endregion		

		private void timer1_Tick(object sender, System.EventArgs e)
		{
			timer1.Enabled = false;
			//
			if (this.txtSpecimenUID.Text.Trim().Length >= 10)
			{
				this.errError.SetVbecsError(this.txtSpecimenUID, string.Empty); // **** 508 Compliance ***
				//
				using (new WaitCursor())
				{
					BOL.Specimen specimen = new BOL.Specimen(this.txtSpecimenUID.Text);
					if (_orders.SelectedOrder is BOL.OrderedComponent)
					{
						((BOL.OrderedComponent ) _orders.SelectedOrder).AssociateWithSpecimen(specimen); // CR3114 todo3114
					}
					else
					{
						((BOL.OrderedTest ) _orders.SelectedOrder).Specimen = specimen;
					}
					// This will trigger BOL.checking
					_orders.SelectedOrder = _orders.SelectedOrder;
				}
			}
			else if (this.txtSpecimenUID.Text.Length > 0 && this.txtSpecimenUID.Text.Trim() != "NRQ")
			{
				this.errError.SetVbecsError(this.txtSpecimenUID, Common.StrRes.Tooltips.UC016.SpecimenUIDLength().ResString); // **** 508 Compliance ***
				this.ttToolTip.SetToolTip(this.btnAccept,  Common.StrRes.Tooltips.UC016.SpecimenUIDLength().ResString);
				this.btnAccept.EnabledButton = false;
			}
		}

		/// <summary>
		/// **** 508 Compliance ***
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void FrmPendingOrderSearch_KeyDownSpeakMessage(object sender, System.EventArgs e)
		{
			string textToSpeak = "";

			if (this.btnAccept.EnabledButton == false)
			{
				textToSpeak = this.ttToolTip.GetToolTip(btnAccept);
			}

			this.SpeakMessage( textToSpeak );		
		}
		
	}
}

